/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

public class ALPNExtension
extends HelloExtension {
    private static final int ID = ExtensionType.EXT_ALPN.id;
    private final List<String> protocols = new ArrayList<String>();
    private final byte[] content;

    public ALPNExtension(List<String> protocols) throws SSLProtocolException {
        super(ExtensionType.get(ID));
        this.protocols.addAll(protocols);
        this.content = this.init();
    }

    public ALPNExtension(HandshakeInStream input, int length) throws IOException {
        super(ExtensionType.get(ID));
        byte[] protocolBytes;
        for (length = input.getInt16(); length > 0; length -= 1 + protocolBytes.length) {
            protocolBytes = input.getBytes8();
            this.protocols.add(new String(protocolBytes, "UTF-8"));
        }
        this.content = this.init();
    }

    private byte[] init() throws SSLProtocolException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (String protocol : this.protocols) {
            byte[] protocolBytes = protocol.getBytes(Charset.forName("UTF-8"));
            int length = protocolBytes.length;
            if (length > 255) {
                throw new SSLProtocolException("Protocol name too long: " + protocol);
            }
            bytes.write(length);
            bytes.write(protocolBytes, 0, length);
        }
        byte[] protocolsBytes = bytes.toByteArray();
        byte[] result = new byte[2 + protocolsBytes.length];
        result[0] = (byte)((protocolsBytes.length & 0xFF00) >> 8);
        result[1] = (byte)(protocolsBytes.length & 0xFF);
        System.arraycopy(protocolsBytes, 0, result, 2, protocolsBytes.length);
        return result;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    int length() {
        return 4 + this.content.length;
    }

    void send(HandshakeOutStream out) throws IOException {
        out.putInt16(ID);
        out.putInt16(this.content.length);
        out.write(this.content, 0, this.content.length);
    }

    public String toString() {
        return "Extension " + this.type + ", protocols: " + this.protocols;
    }
}

