// ========================================================================
// Copyright 2007 Dojo Foundation
// ------------------------------------------------------------------------
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at 
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//========================================================================

package dojox.cometd;

import java.util.Map;
import java.util.Queue;

/* ------------------------------------------------------------ */
/** A Bayeux Client.
 * A client may subscribe to channels and publish messages to channels.
 * Client instances should not be directly created by uses, but should 
 * be obtained via the {@link Bayeux#getClient(String)} or {@link Bayeux#newClient(String, Receiver)}
 * methods.
 */
public interface Client
{
    /* ------------------------------------------------------------ */
    public abstract void remove(boolean timeout);

    /* ------------------------------------------------------------ */
    public abstract String getId();

    /* ------------------------------------------------------------ */
    public abstract boolean hasMessages();

    /* ------------------------------------------------------------ */
    /** Take any messages queued for a client.
     * 
     */
    public abstract Queue<Map<String, Object>> takeMessages();

    /* ------------------------------------------------------------ */
    /** Deliver a message to the client
     * Deliver a message directly to the client. The message is not 
     * filtered or published to a channel.
     */
    public void deliver(Client from, Map<String,Object> message);

    /* ------------------------------------------------------------ */
    public void setListener(Listener listener);

    /* ------------------------------------------------------------ */
    public Listener getListener();

    /* ------------------------------------------------------------ */
    /**
     * @return True if the client is local
     */
    public boolean isLocal();
    
}