/*
 * Decompiled with CFR 0.152.
 */
package com.github.madgnome.maven.h2spec;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.madgnome.maven.h2spec.Failure;
import com.github.madgnome.maven.h2spec.H2SpecTestSuite;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.output.WaitingConsumer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestcontainersConfiguration;

@Mojo(name="h2spec", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class Http2SpecMojo
extends AbstractMojo {
    @Parameter(property="h2spec.port", defaultValue="-1", required=true)
    private int port;
    @Parameter(property="h2spec.timeout", defaultValue="2")
    private int timeout;
    @Parameter(property="h2spec.maxHeaderLength", defaultValue="4000")
    private int maxHeaderLength;
    @Parameter(property="h2spec.excludeSpecs")
    private List<String> excludeSpecs;
    @Parameter(property="h2spec.mainClass", required=true)
    private String mainClass;
    @Parameter(property="h2spec.waitTime")
    private long waitTime = 10000L;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="h2spec.junitFileName", defaultValue="TEST-h2spec.xml")
    private String junitFileName;
    @Parameter(property="h2spec.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="h2spec.version", defaultValue="2.6.0")
    private String h2specVersion;
    @Parameter(property="h2spec.containerName", defaultValue="summerwind/h2spec")
    private String h2specContainerName;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="h2spec.junitPackage", defaultValue="h2spec")
    private String junitPackage;
    @Parameter(property="h2spec.reportsDirectory", defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getTestClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            classpathElements.add(this.project.getBuild().getTestOutputDirectory());
            return new URLClassLoader((URL[])classpathElements.stream().map(s -> {
                try {
                    return new File((String)s).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }).toArray(URL[]::new), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip execution of h2spec-maven-plugin");
            return;
        }
        AtomicReference error = new AtomicReference();
        Thread runner = null;
        try {
            String host;
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                this.getLog().debug((CharSequence)"Unable to detect localhost address, using 127.0.0.1 as fallback");
                host = "127.0.0.1";
            }
            if (this.port == -1) {
                this.port = this.findRandomOpenPortOnAllLocalInterfaces();
            }
            ClassLoader ori = Thread.currentThread().getContextClassLoader();
            runner = new Thread(() -> {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.mainClass);
                    Method main = clazz.getMethod("main", String[].class);
                    main.invoke(null, new Object[]{new String[]{String.valueOf(this.port)}});
                }
                catch (Throwable e) {
                    error.set(e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ori);
                }
            });
            runner.setDaemon(true);
            runner.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            if (this.waitTime <= 0L) {
                this.waitTime = 10000L;
            }
            long sleepTime = this.waitTime / 10L;
            for (int i = 0; i < 10; ++i) {
                Throwable cause = (Throwable)error.get();
                if (cause != null) {
                    throw new MojoExecutionException("Unable to start server", cause);
                }
                try (Socket socket = new Socket();){
                    socket.connect(new InetSocketAddress(host, this.port));
                    break;
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                    }
                    if (i != 9) continue;
                    throw new MojoExecutionException("Unable to connect to server in " + this.waitTime, (Throwable)error.get());
                }
            }
            if (this.excludeSpecs == null) {
                this.excludeSpecs = Collections.emptyList();
            }
            try {
                this.getLog().info((CharSequence)"!!! Exclude specs");
                for (String excludeSpec : this.excludeSpecs) {
                    this.getLog().info((CharSequence)excludeSpec);
                }
                ArrayList nonIgnoredFailures = new ArrayList();
                ArrayList ignoredFailures = new ArrayList();
                if (!Files.exists(this.reportsDirectory.toPath(), new LinkOption[0])) {
                    this.getLog().debug((CharSequence)("Reports directory " + this.reportsDirectory.getAbsolutePath() + " does not exist, try creating it..."));
                    if (this.reportsDirectory.mkdirs()) {
                        this.getLog().debug((CharSequence)("Reports directory " + this.reportsDirectory.getAbsolutePath() + " created."));
                    } else {
                        this.getLog().debug((CharSequence)"Failed to create report directory");
                    }
                }
                File junitFile = new File(this.reportsDirectory, this.junitFileName);
                junitFile.createNewFile();
                String imageName = this.h2specContainerName + ":" + this.h2specVersion;
                String command = String.format("-h %s -p %d -j %s -o %d --max-header-length %d", "host.testcontainers.internal", this.port, "./junit.xml", this.timeout, this.maxHeaderLength);
                if (this.verbose) {
                    command = command + " -v";
                }
                this.getLog().info((CharSequence)("running image: " + imageName + " with command: " + command));
                Testcontainers.exposeHostPorts((int[])new int[]{this.port});
                try (GenericContainer h2spec = new GenericContainer(DockerImageName.parse((String)imageName));){
                    if (this.verbose) {
                        h2spec.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName())));
                    }
                    h2spec.setWaitStrategy((WaitStrategy)new LogMessageWaitStrategy().withStartLine("Finished in "));
                    h2spec.setPortBindings(Arrays.asList(Integer.toString(this.port)));
                    h2spec.withCommand(command);
                    h2spec.start();
                    h2spec.copyFileFromContainer("./junit.xml", junitFile.getAbsolutePath());
                }
                this.cleanupJunitReportFileOnlyTime(junitFile);
                List<Failure> allFailures = H2SpecTestSuite.parseReports(this.getLog(), junitFile.getParentFile(), new HashSet<String>(this.excludeSpecs));
                allFailures.forEach(failure -> {
                    if (failure.isIgnored()) {
                        ignoredFailures.add(failure);
                    } else {
                        nonIgnoredFailures.add(failure);
                    }
                });
                if (nonIgnoredFailures.size() > 0) {
                    StringBuilder sb = new StringBuilder("\nFailed test cases:\n");
                    nonIgnoredFailures.forEach(failure -> sb.append("\t").append(failure.toString()).append("\n\n"));
                    if (!this.testFailureIgnore) {
                        throw new MojoFailureException(sb.toString());
                    }
                } else {
                    this.getLog().info((CharSequence)("All test cases passed. " + ignoredFailures.size() + " test cases ignored."));
                    this.markedFailedTestAsSkipped(junitFile.toPath());
                }
                this.cleanupJunitReportFile(junitFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        finally {
            if (runner != null) {
                runner.interrupt();
            }
        }
    }

    protected void markedFailedTestAsSkipped(Path junitFile) throws IOException, XmlPullParserException {
        Xpp3Dom dom;
        if (this.excludeSpecs == null || this.excludeSpecs.isEmpty()) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(junitFile);){
            dom = Xpp3DomBuilder.build((Reader)reader);
            Arrays.stream(dom.getChildren()).forEach(testsuite -> {
                if (!"0".equals(testsuite.getAttribute("errors"))) {
                    Arrays.stream(testsuite.getChildren()).forEach(testcase -> {
                        if (testcase.getChild("error") != null) {
                            int skipped = Integer.valueOf(testsuite.getAttribute("skipped"));
                            int errors = Integer.valueOf(testsuite.getAttribute("errors"));
                            testsuite.setAttribute("skipped", Integer.toString(++skipped));
                            testsuite.setAttribute("errors", Integer.toString(--errors));
                            Xpp3Dom skippedDom = new Xpp3Dom("skipped");
                            skippedDom.setValue(testcase.getChild(0).getValue());
                            testcase.addChild(skippedDom);
                            testcase.removeChild(0);
                        }
                    });
                }
            });
        }
        try (BufferedWriter writer = Files.newBufferedWriter(junitFile, new OpenOption[0]);){
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)dom);
        }
    }

    private void cleanupJunitReportFile(File junitFile) throws IOException, XmlPullParserException {
        Xpp3Dom dom;
        try (BufferedReader reader = Files.newBufferedReader(junitFile.toPath());){
            dom = Xpp3DomBuilder.build((Reader)reader);
            Arrays.stream(dom.getChildren()).forEach(testsuite -> {
                testsuite.setAttribute("package", "");
                testsuite.setAttribute("id", "");
                Arrays.stream(testsuite.getChildren()).forEach(testcase -> {
                    String className = testcase.getAttribute("classname");
                    testcase.setAttribute("classname", this.junitPackage + "." + StringUtils.replace((String)testsuite.getAttribute("name"), (char)' ', (char)'_'));
                    testcase.setAttribute("package", "");
                    testcase.setAttribute("name", StringUtils.replace((String)className, (char)' ', (char)'_'));
                });
            });
        }
        try (BufferedWriter writer = Files.newBufferedWriter(junitFile.toPath(), new OpenOption[0]);){
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)dom);
        }
    }

    private void cleanupJunitReportFileOnlyTime(File junitFile) throws IOException, XmlPullParserException {
        Xpp3Dom dom;
        DecimalFormat df = new DecimalFormat("#.#####");
        try (BufferedReader reader = Files.newBufferedReader(junitFile.toPath());){
            dom = Xpp3DomBuilder.build((Reader)reader);
            Arrays.stream(dom.getChildren()).forEach(testsuite -> {
                float[] time = new float[]{0.0f};
                Arrays.stream(testsuite.getChildren()).forEach(testcase -> {
                    time[0] = time[0] + Float.parseFloat(testcase.getAttribute("time"));
                });
                testsuite.setAttribute("time", df.format(time[0]));
            });
        }
        try (BufferedWriter writer = Files.newBufferedWriter(junitFile.toPath(), new OpenOption[0]);){
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)dom);
        }
    }

    private int findRandomOpenPortOnAllLocalInterfaces() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Can't find an open socket", e);
            }
        }
        socket.close();
        return n;
    }

    public void setExcludeSpecs(List<String> excludeSpecs) {
        this.excludeSpecs = excludeSpecs;
    }

    static {
        TestcontainersConfiguration.getInstance().getProperties().setProperty("transport.type", "httpclient5");
    }

    static class LogMessageWaitStrategy
    extends AbstractWaitStrategy {
        private String startLine;
        private int times = 1;

        LogMessageWaitStrategy() {
        }

        protected void waitUntilReady() {
            WaitingConsumer waitingConsumer = new WaitingConsumer();
            LogContainerCmd cmd = DockerClientFactory.instance().client().logContainerCmd(this.waitStrategyTarget.getContainerId()).withFollowStream(Boolean.valueOf(true)).withSince(Integer.valueOf(0)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true));
            try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
                callback.addConsumer(OutputFrame.OutputType.STDOUT, (Consumer)waitingConsumer);
                callback.addConsumer(OutputFrame.OutputType.STDERR, (Consumer)waitingConsumer);
                cmd.exec((ResultCallback)callback);
                Predicate<OutputFrame> waitPredicate = outputFrame -> {
                    String line = outputFrame.getUtf8String();
                    return line.startsWith(this.startLine);
                };
                try {
                    waitingConsumer.waitUntil(waitPredicate, this.startupTimeout.getSeconds(), TimeUnit.SECONDS, this.times);
                }
                catch (TimeoutException e) {
                    throw new ContainerLaunchException("Timed out waiting for log output matching '" + this.startLine + "'");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public LogMessageWaitStrategy withStartLine(String startLine) {
            this.startLine = startLine;
            return this;
        }

        public LogMessageWaitStrategy withStartLine(int times) {
            this.times = times;
            return this;
        }
    }
}

