/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.mortbay.jetty.plugin.JettyWebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenWebInfConfiguration
extends WebInfConfiguration {
    protected Resource _originalResourceBase;
    protected Resource[] _unpackedOverlays;

    public void configure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Setting up classpath ...");
            }
            Iterator<File> itor = jwac.getClassPathFiles().iterator();
            while (itor.hasNext()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(itor.next().getCanonicalPath());
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Classpath = " + LazyList.array2List((Object[])((URLClassLoader)context.getClassLoader()).getURLs())));
            }
        }
        super.configure(context);
        String[] existingServerClasses = context.getServerClasses();
        String[] newServerClasses = new String[2 + (existingServerClasses == null ? 0 : existingServerClasses.length)];
        newServerClasses[0] = "org.apache.maven.";
        newServerClasses[1] = "org.codehaus.plexus.";
        System.arraycopy(existingServerClasses, 0, newServerClasses, 2, existingServerClasses.length);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Server classes:");
            for (int i = 0; i < newServerClasses.length; ++i) {
                Log.debug((String)newServerClasses[i]);
            }
        }
        context.setServerClasses(newServerClasses);
    }

    public void preConfigure(WebAppContext context) throws Exception {
        super.preConfigure(context);
        this._originalResourceBase = context.getBaseResource();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getOverlays() != null && !jwac.getOverlays().isEmpty()) {
            Resource[] origResources = null;
            int origSize = 0;
            if (jwac.getBaseResource() != null) {
                if (jwac.getBaseResource() instanceof ResourceCollection) {
                    origResources = ((ResourceCollection)jwac.getBaseResource()).getResources();
                    origSize = origResources.length;
                } else {
                    origResources = new Resource[]{jwac.getBaseResource()};
                    origSize = 1;
                }
            }
            int overlaySize = jwac.getOverlays().size();
            Resource[] newResources = new Resource[origSize + overlaySize];
            int offset = 0;
            if (origSize > 0) {
                if (jwac.getBaseAppFirst()) {
                    System.arraycopy(origResources, 0, newResources, 0, origSize);
                    offset = origSize;
                } else {
                    System.arraycopy(origResources, 0, newResources, overlaySize, origSize);
                }
            }
            this._unpackedOverlays = new Resource[overlaySize];
            List<Resource> overlays = jwac.getOverlays();
            for (int idx = 0; idx < overlaySize; ++idx) {
                this._unpackedOverlays[idx] = this.unpackOverlay(context, overlays.get(idx));
                newResources[idx + offset] = this._unpackedOverlays[idx];
                Log.info((String)("Adding overlay: " + this._unpackedOverlays[idx]));
            }
            jwac.setBaseResource((Resource)new ResourceCollection(newResources));
        }
    }

    public void postConfigure(WebAppContext context) throws Exception {
        super.postConfigure(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (this._unpackedOverlays != null && this._unpackedOverlays.length > 0) {
            try {
                for (int i = 0; i < this._unpackedOverlays.length; ++i) {
                    IO.delete((File)this._unpackedOverlays[i].getFile());
                }
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
        }
        super.deconfigure(context);
        context.setBaseResource(this._originalResourceBase);
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        List superList;
        ArrayList<Resource> list = new ArrayList<Resource>();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            for (File f : jwac.getClassPathFiles()) {
                if (!f.getName().toLowerCase().endsWith(".jar")) continue;
                try {
                    list.add(Resource.newResource((URI)f.toURI()));
                }
                catch (Exception e) {
                    Log.warn((String)"Bad url ", (Throwable)e);
                }
            }
        }
        if ((superList = super.findJars(context)) != null) {
            list.addAll(superList);
        }
        return list;
    }

    protected Resource unpackOverlay(WebAppContext context, Resource overlay) throws IOException {
        int i;
        this.resolveTempDirectory(context);
        String name = overlay.getName();
        if (name.endsWith("!/")) {
            name = name.substring(0, name.length() - 2);
        }
        if ((i = name.lastIndexOf(47)) > 0) {
            name = name.substring(i + 1, name.length());
        }
        name = name.replace('.', '_');
        File dir = new File(context.getTempDirectory(), name);
        overlay.copyTo(dir);
        Resource unpackedOverlay = Resource.newResource((String)dir.getCanonicalPath());
        return unpackedOverlay;
    }
}

