/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.IOException;
import org.mortbay.jetty.plugin.AbstractJettyMojo;

public class ConsoleScanner
extends Thread {
    private final AbstractJettyMojo mojo;

    public ConsoleScanner(AbstractJettyMojo mojo) {
        this.mojo = mojo;
        this.setName("Console scanner");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.checkSystemInput();
                this.getSomeSleep();
            }
        }
        catch (IOException e) {
            this.mojo.getLog().warn((Throwable)e);
            return;
        }
    }

    private void getSomeSleep() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.mojo.getLog().debug((Throwable)e);
        }
    }

    private void checkSystemInput() throws IOException {
        while (System.in.available() > 0) {
            char c;
            int inputByte = System.in.read();
            if (inputByte < 0 || (c = (char)inputByte) != '\n') continue;
            this.restartWebApp();
        }
    }

    private void clearInputBuffer() {
        try {
            while (System.in.available() > 0) {
                long available = System.in.available();
                int i = 0;
                while ((long)i < available && System.in.read() != -1) {
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.mojo.getLog().warn((CharSequence)"Error discarding console input buffer", (Throwable)e);
        }
    }

    private void restartWebApp() {
        try {
            this.mojo.restartWebApp(false);
            this.clearInputBuffer();
        }
        catch (Exception e) {
            this.mojo.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after a new line on the console", (Throwable)e);
        }
    }
}

