/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jetty.annotations.ContainerInitializerConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.mortbay.jetty.plugin.MavenAnnotationConfiguration;
import org.mortbay.jetty.plugin.MavenWebInfConfiguration;

public class JettyWebAppContext
extends WebAppContext {
    private static final String WEB_INF_CLASSES_PREFIX = "/WEB-INF/classes";
    private static final String WEB_INF_LIB_PREFIX = "/WEB-INF/lib";
    private final List<File> webInfClasses = new ArrayList<File>();
    private final List<File> webInfJars = new ArrayList<File>();
    private final Map<String, File> webInfJarMap = new HashMap<String, File>();
    private final EnvConfiguration envConfig;
    private List<File> classpathFiles;
    private String jettyEnvXml;
    private List<Resource> overlays;
    private boolean unpackOverlays;
    private String containerIncludeJarPattern = ".*/servlet-api-[^/]*\\.jar$";
    private boolean copyWebInf;
    private boolean baseAppFirst = true;

    public JettyWebAppContext() throws Exception {
        Configuration[] configurationArray = new Configuration[9];
        configurationArray[0] = new MavenWebInfConfiguration();
        configurationArray[1] = new WebXmlConfiguration();
        configurationArray[2] = new MetaInfConfiguration();
        configurationArray[3] = new FragmentConfiguration();
        this.envConfig = new EnvConfiguration();
        configurationArray[4] = this.envConfig;
        configurationArray[5] = new PlusConfiguration();
        configurationArray[6] = new MavenAnnotationConfiguration();
        configurationArray[7] = new JettyWebXmlConfiguration();
        configurationArray[8] = new ContainerInitializerConfiguration();
        this.setConfigurations(configurationArray);
        super.setCopyWebInf(false);
    }

    public void setContainerIncludeJarPattern(String pattern) {
        this.containerIncludeJarPattern = pattern;
    }

    public String getContainerIncludeJarPattern() {
        return this.containerIncludeJarPattern;
    }

    public boolean getUnpackOverlays() {
        return this.unpackOverlays;
    }

    public void setUnpackOverlays(boolean unpackOverlays) {
        this.unpackOverlays = unpackOverlays;
    }

    public void setClassPathFiles(List<File> classpathFiles) {
        this.classpathFiles = classpathFiles;
    }

    public List<File> getClassPathFiles() {
        return this.classpathFiles;
    }

    public void setOverlays(List<Resource> overlays) {
        this.overlays = overlays;
    }

    public List<Resource> getOverlays() {
        return this.overlays;
    }

    public void setJettyEnvXml(String jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
    }

    public String getJettyEnvXml() {
        return this.jettyEnvXml;
    }

    public void setWebInfClasses(List<File> dirs) {
        this.webInfClasses.addAll(dirs);
    }

    public List<File> getWebInfClasses() {
        return this.webInfClasses;
    }

    public void setWebInfLib(List<File> jars) {
        this.webInfJars.addAll(jars);
    }

    public void setCopyWebInf(boolean value) {
        this.copyWebInf = value;
    }

    public boolean isCopyWebInf() {
        return this.copyWebInf;
    }

    public void setBaseAppFirst(boolean value) {
        this.baseAppFirst = value;
    }

    public boolean getBaseAppFirst() {
        return this.baseAppFirst;
    }

    public void setResourceBases(String[] resourceBases) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String rl : resourceBases) {
            String[] rs;
            for (String r : rs = rl.split(" *, *")) {
                resources.add(r);
            }
        }
        this.setBaseResource((Resource)new ResourceCollection(resources.toArray(new String[resources.size()])));
    }

    public List<File> getWebInfLib() {
        return this.webInfJars;
    }

    public void doStart() throws Exception {
        this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", this.containerIncludeJarPattern);
        this.webInfJarMap.clear();
        for (File file : this.webInfJars) {
            String fileName = file.getName();
            if (!fileName.endsWith(".jar")) continue;
            this.webInfJarMap.put(fileName, file);
        }
        if (this.jettyEnvXml != null) {
            this.envConfig.setJettyEnvXml(Resource.toURL((File)new File(this.jettyEnvXml)));
        }
        this.setShutdown(false);
        super.doStart();
    }

    public void doStop() throws Exception {
        this.setShutdown(true);
        Thread.currentThread();
        Thread.sleep(500L);
        super.doStop();
    }

    public Resource getResource(String uriInContext) throws MalformedURLException {
        Resource resource = null;
        resource = super.getResource(uriInContext);
        if (!(resource != null && resource.exists() || uriInContext == null || this.webInfClasses == null)) {
            String uri = URIUtil.canonicalPath((String)uriInContext);
            try {
                if (uri.startsWith(WEB_INF_CLASSES_PREFIX)) {
                    Resource res = null;
                    int i = 0;
                    while (res == null && i < this.webInfClasses.size()) {
                        String newPath = uri.replace(WEB_INF_CLASSES_PREFIX, this.webInfClasses.get(i).getPath());
                        res = Resource.newResource((String)newPath);
                        if (res.exists()) continue;
                        res = null;
                        ++i;
                    }
                    return res;
                }
                if (uri.startsWith(WEB_INF_LIB_PREFIX)) {
                    String jarName = uri.replace(WEB_INF_LIB_PREFIX, "");
                    if (jarName.startsWith("/") || jarName.startsWith("\\")) {
                        jarName = jarName.substring(1);
                    }
                    if (jarName.length() == 0) {
                        return null;
                    }
                    File jarFile = this.webInfJarMap.get(jarName);
                    if (jarFile != null) {
                        return Resource.newResource((String)jarFile.getPath());
                    }
                    return null;
                }
            }
            catch (MalformedURLException e) {
                throw e;
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
        }
        return resource;
    }

    public Set<String> getResourcePaths(String path) {
        Set<String> paths;
        block2: {
            block3: {
                paths = super.getResourcePaths(path);
                if (!paths.isEmpty() || path == null) break block2;
                if (!(path = URIUtil.canonicalPath((String)path)).startsWith(WEB_INF_LIB_PREFIX)) break block3;
                paths = new TreeSet<String>();
                for (String fileName : this.webInfJarMap.keySet()) {
                    paths.add("/WEB-INF/lib/" + fileName);
                }
                break block2;
            }
            if (!path.startsWith(WEB_INF_CLASSES_PREFIX)) break block2;
            for (int i = 0; paths.isEmpty() && i < this.webInfClasses.size(); ++i) {
                String newPath = path.replace(WEB_INF_CLASSES_PREFIX, this.webInfClasses.get(i).getPath());
                paths = super.getResourcePaths(newPath);
            }
        }
        return paths;
    }
}

