/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.NamingEntryUtil;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public abstract class NamingEntry {
    public static final String __contextName = "__";
    protected String jndiName;
    protected Object objectToBind;
    protected String namingEntryNameString;
    protected String objectNameString;

    public NamingEntry(Object scope, String jndiName, Object object) throws NamingException {
        this.jndiName = jndiName;
        this.objectToBind = object;
        this.save(scope);
    }

    public NamingEntry(String jndiName, Object object) throws NamingException {
        this(null, jndiName, object);
    }

    public void bindToENC(String localName) throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp/env");
        Log.debug((String)("Binding java:comp/env/" + localName + " to " + this.objectNameString));
        NamingUtil.bind((Context)env, (String)localName, (Object)new LinkRef(this.objectNameString));
    }

    public void unbindENC() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp/env");
            Log.debug((String)("Unbinding java:comp/env/" + this.getJndiName()));
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }

    public void release() {
        try {
            InitialContext ic = new InitialContext();
            ic.unbind(this.objectNameString);
            ic.unbind(this.namingEntryNameString);
            this.jndiName = null;
            this.namingEntryNameString = null;
            this.objectNameString = null;
            this.objectToBind = null;
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Object getObjectToBind() throws NamingException {
        return this.objectToBind;
    }

    protected void save(Object scope) throws NamingException {
        InitialContext ic = new InitialContext();
        NameParser parser = ic.getNameParser("");
        Name prefix = NamingEntryUtil.getNameForScope(scope);
        Name namingEntryName = NamingEntryUtil.makeNamingEntryName(parser, this.getJndiName());
        namingEntryName.addAll(0, prefix);
        this.namingEntryNameString = namingEntryName.toString();
        NamingUtil.bind((Context)ic, (String)this.namingEntryNameString, (Object)this);
        Name objectName = parser.parse(this.getJndiName());
        objectName.addAll(0, prefix);
        this.objectNameString = objectName.toString();
        NamingUtil.bind((Context)ic, (String)this.objectNameString, (Object)this.objectToBind);
    }
}

