/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.testing;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.EventListener;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.LocalConnector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.util.Attributes;

public class ServletTester {
    Server _server = new Server();
    LocalConnector _connector = new LocalConnector();
    Context _context = new Context(3);

    public ServletTester() {
        try {
            this._server.setSendServerVersion(false);
            this._server.addConnector((Connector)this._connector);
            this._server.addHandler((Handler)this._context);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() throws Exception {
        this._server.start();
    }

    public void stop() throws Exception {
        this._server.stop();
    }

    public String getResponses(String rawRequests) throws Exception {
        this._connector.reopen();
        String responses = this._connector.getResponses(rawRequests);
        return responses;
    }

    public ByteArrayBuffer getResponses(ByteArrayBuffer rawRequests) throws Exception {
        this._connector.reopen();
        ByteArrayBuffer responses = this._connector.getResponses(rawRequests, false);
        return responses;
    }

    public String createSocketConnector(boolean localhost) throws Exception {
        SocketConnector connector = new SocketConnector();
        if (localhost) {
            connector.setHost("127.0.0.1");
        }
        this._server.addConnector((Connector)connector);
        if (this._server.isStarted()) {
            connector.start();
        } else {
            connector.open();
        }
        return "http://" + (localhost ? "127.0.0.1" : InetAddress.getLocalHost().getHostAddress()) + ":" + connector.getLocalPort();
    }

    public void addEventListener(EventListener listener) {
        this._context.addEventListener(listener);
    }

    public FilterHolder addFilter(Class filterClass, String pathSpec, int dispatches) {
        return this._context.addFilter(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(String filterClass, String pathSpec, int dispatches) {
        return this._context.addFilter(filterClass, pathSpec, dispatches);
    }

    public ServletHolder addServlet(Class servlet, String pathSpec) {
        return this._context.addServlet(servlet, pathSpec);
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this._context.addServlet(className, pathSpec);
    }

    public Object getAttribute(String name) {
        return this._context.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._context.getAttributeNames();
    }

    public Attributes getAttributes() {
        return this._context.getAttributes();
    }

    public String getResourceBase() {
        return this._context.getResourceBase();
    }

    public void setAttribute(String name, Object value) {
        this._context.setAttribute(name, value);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._context.setClassLoader(classLoader);
    }

    public void setContextPath(String contextPath) {
        this._context.setContextPath(contextPath);
    }

    public void setEventListeners(EventListener[] eventListeners) {
        this._context.setEventListeners(eventListeners);
    }

    public void setResourceBase(String resourceBase) {
        this._context.setResourceBase(resourceBase);
    }
}

