/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.AbstractList;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayQueue<E>
extends AbstractList<E>
implements Queue<E> {
    public final int DEFAULT_CAPACITY = 64;
    public final int DEFAULT_GROWTH = 32;
    private Object _lock = this;
    private Object[] _elements;
    private int _nextE;
    private int _nextSlot;
    private int _size;
    private int _growCapacity;

    public ArrayQueue() {
        this._elements = new Object[64];
        this._growCapacity = 32;
    }

    public ArrayQueue(int capacity) {
        this._elements = new Object[capacity];
        this._growCapacity = -1;
    }

    public ArrayQueue(int initCapacity, int growBy) {
        this._elements = new Object[initCapacity];
        this._growCapacity = growBy;
    }

    public ArrayQueue(int initCapacity, int growBy, Object lock) {
        this._elements = new Object[initCapacity];
        this._growCapacity = growBy;
        this._lock = lock;
    }

    public int getCapacity() {
        return this._elements.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Object object = this._lock;
        synchronized (object) {
            ++this._size;
            this._elements[this._nextSlot++] = e;
            if (this._nextSlot == this._elements.length) {
                this._nextSlot = 0;
            }
            if (this._nextSlot == this._nextE) {
                this.grow();
            }
        }
        return true;
    }

    public void addUnsafe(E e) {
        ++this._size;
        this._elements[this._nextSlot++] = e;
        if (this._nextSlot == this._elements.length) {
            this._nextSlot = 0;
        }
        if (this._nextSlot == this._nextE) {
            this.grow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E element() {
        Object object = this._lock;
        synchronized (object) {
            if (this._nextSlot == this._nextE) {
                throw new NoSuchElementException();
            }
            return (E)this._elements[this._nextE];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Object object = this._lock;
        synchronized (object) {
            ++this._size;
            this._elements[this._nextSlot++] = e;
            if (this._nextSlot == this._elements.length) {
                this._nextSlot = 0;
            }
            if (this._nextSlot == this._nextE) {
                if (this._growCapacity <= 0) {
                    return false;
                }
                Object[] elements = new Object[this._elements.length + this._growCapacity];
                int split = this._elements.length - this._nextE;
                if (split > 0) {
                    System.arraycopy(this._elements, this._nextE, elements, 0, split);
                }
                if (this._nextE != 0) {
                    System.arraycopy(this._elements, 0, elements, split, this._nextSlot);
                }
                this._elements = elements;
                this._nextE = 0;
                this._nextSlot = this._size;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this._lock;
        synchronized (object) {
            if (this._nextSlot == this._nextE) {
                return null;
            }
            return (E)this._elements[this._nextE];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object object = this._lock;
        synchronized (object) {
            if (this._size == 0) {
                return null;
            }
            Object e = this._elements[this._nextE];
            this._elements[this._nextE] = null;
            --this._size;
            if (++this._nextE == this._elements.length) {
                this._nextE = 0;
            }
            return (E)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        Object object = this._lock;
        synchronized (object) {
            if (this._nextSlot == this._nextE) {
                throw new NoSuchElementException();
            }
            Object e = this._elements[this._nextE++];
            if (this._nextE == this._elements.length) {
                this._nextE = 0;
            }
            return (E)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._size = 0;
            this._nextE = 0;
            this._nextSlot = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this._lock;
        synchronized (object) {
            return this._size == 0;
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            int i = this._nextE + index;
            if (i >= this._elements.length) {
                i -= this._elements.length;
            }
            return (E)this._elements[i];
        }
    }

    public E getUnsafe(int index) {
        int i = this._nextE + index;
        if (i >= this._elements.length) {
            i -= this._elements.length;
        }
        return (E)this._elements[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            int i = this._nextE + index;
            if (i >= this._elements.length) {
                i -= this._elements.length;
            }
            Object old = this._elements[i];
            if (i < this._nextSlot) {
                System.arraycopy(this._elements, i + 1, this._elements, i, this._nextSlot - i);
                --this._nextSlot;
                --this._size;
            } else {
                System.arraycopy(this._elements, i + 1, this._elements, i, this._elements.length - 1);
                if (this._nextSlot > 0) {
                    this._elements[this._elements.length] = this._elements[0];
                    System.arraycopy(this._elements, 1, this._elements, 0, this._nextSlot - 1);
                    --this._nextSlot;
                } else {
                    this._nextSlot = this._elements.length - 1;
                }
                --this._size;
            }
            return (E)old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            int i = this._nextE + index;
            if (i >= this._elements.length) {
                i -= this._elements.length;
            }
            Object old = this._elements[i];
            this._elements[i] = element;
            return (E)old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            if (index == this._size) {
                this.add(element);
            } else {
                int i = this._nextE + index;
                if (i >= this._elements.length) {
                    i -= this._elements.length;
                }
                ++this._size;
                ++this._nextSlot;
                if (this._nextSlot == this._elements.length) {
                    this._nextSlot = 0;
                }
                if (this._nextSlot == this._nextE) {
                    this.grow();
                }
                if (i < this._nextSlot) {
                    System.arraycopy(this._elements, i, this._elements, i + 1, this._nextSlot - i);
                    this._elements[i] = element;
                } else {
                    if (this._nextSlot > 0) {
                        System.arraycopy(this._elements, 0, this._elements, 1, this._nextSlot);
                        this._elements[0] = this._elements[this._elements.length - 1];
                    }
                    System.arraycopy(this._elements, i, this._elements, i + 1, this._elements.length - i - 1);
                    this._elements[i] = element;
                }
            }
        }
    }

    protected void grow() {
        if (this._growCapacity <= 0) {
            throw new IllegalStateException("Full");
        }
        Object[] elements = new Object[this._elements.length + this._growCapacity];
        int split = this._elements.length - this._nextE;
        if (split > 0) {
            System.arraycopy(this._elements, this._nextE, elements, 0, split);
        }
        if (this._nextE != 0) {
            System.arraycopy(this._elements, 0, elements, split, this._nextSlot);
        }
        this._elements = elements;
        this._nextE = 0;
        this._nextSlot = this._size;
    }
}

