/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.impl;

import java.util.ArrayList;
import java.util.Collection;

import com.sun.appserv.ha.spi.CompositeMetaData;
import com.sun.appserv.ha.spi.MetaData;

/**
 * An implementation of CompositeMetaData. 
 */ 
public class CompositeMetaDataImpl<T extends MetaData>
    extends MetaDataImpl
    implements CompositeMetaData<T> {

    
    private Collection<T> entries = new ArrayList<T>();

    /**
     * @param version The version number of this data. A version 
     *  number zero means a freshly created data
     * @param lastAccess The time when the data was last accessed
     * @param maxInactiveInterval The maximum time (in seconds) that this
     *  data can be idle, after which it becomes a candidate for removal
     *  during BackingStore.removeExpired()
     */
    public CompositeMetaDataImpl(long version, long lastAccess,
            long maxInactiveInterval) {
        super(version, lastAccess, maxInactiveInterval);
    }
    
    /**
     * Return the collection of MetaData that is part of this
     *  composite metadata.
     * 
     * @return A Collection whose entries are (atleast) of type
     *  MetaData
     */
    public Collection<T> getEntries() {
        return entries;
    }
    
    /**
     * Add an entry to the collection returned by getEntries(). After
     *  this call the collection returned by getEntries() 
     *  will contain this entry.
     *  
     * @param entry The entry to be added
     */
    public void addEntry(T entry) {
        entries.add(entry);
    }
    
}
