/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

/**
 * A class for storing meta information
 */
public interface MetaData {
    
    /**
     * Get the verion of the state. A freshly created state has a version == 0
     * 
     * @return the version.
     */
    public long getVersion();
    
    /**
     * Get the last access time of the state. This must be used in conjunction
     *  with getMaxInactiveInterval to determine if the state is idle enough
     *  to be removed.
     *  
     * @return The time when the state was accessed last
     * @see getMaxInactiveInterval
     * @see BackingStore.removeExpired() 
     */
    public long getLastAccessTime();
    
    /**
     * Get the maximum time that this state can be idle in the store before
     *  it can be removed.
     *  
     * @return the maximum idle time. If zero or negative, then the component
     *  has no idle timeout limit
     */
    public long getMaxInactiveInterval();    
    
}
