/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

/**
 * A class to hold metadata for web sessions. An instance of this interface is
 *  used to save both simple WEB sessions OR SSO sessions. For web sessions
 *  that are configured to save only "modified" attributes, an instance of a class
 *  that implements CompositeMetaData will be used. 
 *
 * @see CompositeMetaData
 */
public interface WebMetaData
    extends SimpleMetaData {
    
    /**
     * Returns some extra meta information that the store must save.
     * 
     * @return A string containing some meta information
     */
    public String getExtraParam();    
    
}
