/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.impl;

import com.sun.appserv.ha.spi.EjbMetaData;

/**
 * An implementation of EjbMetaData
 */
public class EjbMetaDataImpl
    extends SimpleMetaDataImpl
    implements EjbMetaData {
    
    private String id = null;
    
    private String appid = null;
    
    /**
     * Creates a new instance of EjbMetaDataImpl
     */
    public EjbMetaDataImpl(long version, long lastAccess, 
        long maxInactiveInterval, byte[] state, String appid, String id) {
        super(version, lastAccess, maxInactiveInterval, state);
        this.id = id;
        this.appid = appid;
    }
    
    /**
     * Return the id of this data
     * @return id (key)
     */    
    public String getId() {
        return this.id;
    }
    
    /**
     * Return the appId of the data
     * 
     * @return appid
     */    
    public String getAppId() {
        return this.appid;
    }    
    
}
