/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

import java.util.Properties;

/**
 * A factory for creating BackingStore(s). Every provider must
 * provide an implementation of this interface. The provider must also
 * supply an implementation of com.sun.appserv.server.LifecycleListener
 * interface that registers the BackingStoreFactory class name
 * with BackingStoreRegistry. 
 * 
 * <p> The createStore(env) method is called typically during container 
 * creation time. A store instance is typically used to store state
 * for a single container whose id is passed (as appId) in 
 * createsimplestore and createCompositeStore calls. 
 * The store returned by createBatchBackingStore method is different
 * in the sense that the data passed in the collection may potentially
 * be from different containers/applications.
 * 
 * <p>Any runtime exception thrown from createStore method 
 * ill cause the container to use a default persistence-type and a 
 * log message will be logged at WARNING level.
 * 
 * @see BackingStoreRegistry
 * 
 */
public interface BackingStoreFactory {
	
    /**
     * This method is called to create a BackingStore that will
     *  store WebMetaData or SimpleMetaData. 
     * The factory must return a fully initialized and operational BackingStore
     *  
     * @param appId the application id for which this store is created
     * @param env Properties that contain values specified
     *  in life cycle module.
     * @return a BackingStore
     * @throws BackingStoreException If the store could not be created
     */
    public BackingStore createSimpleStore(String appId, Properties env)
            throws BackingStoreException;
    
    /**
     * This method is called to create a BackingStore that will
     *  store CompositeMetaData. The factory must return a fully 
     *  initialized and operational BackingStore
     * 
     * @param appId the application id for which this store is created
     * @param env Properties that contain values specified
     *  in life cycle module.
     * @return A BackingStore
     * @throws BackingStoreException If the store could not be created
     */
    public BackingStore createCompositeStore(String appId, Properties env)
            throws BackingStoreException;

    /**
     * This method is called to store a set of EjbMetaData 
     *  objects atomically. The factory must return a fully 
     *  initialized and operational BatchBackingStore
     *  
     * @param env Properties that contain values specified
     *  in life cycle module.
     * @return A BatchBackingStore
     * @throws BackingStoreException If the store could not be created
     */
    public BatchBackingStore createBatchBackingStore(Properties env)
            throws BackingStoreException; 
    
}
