/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

import java.util.Collection;

/**
 * A generic class to hold a collection of children MetaData.
 * This class is used mainly to store a collection of
 * AttributeMetaData that are part of a WebSession. The metadata
 * about the web session itself can be obtained directly from the
 * CompositeMetaData itself, while the metadata of its attributes
 * can be obtained from the individual AttributeMetaData that is
 * part of the collection returned by getEntries().
 */
public interface CompositeMetaData<T extends MetaData>
    extends MetaData {
    
    /**
     * Returns a collection of MetaData (or its subclass). Note that
     *  though it is possible to have a CompositeMetaData itself as
     *  part of this collection, typically they contain only
     *  AttributeMetaData
     *  
     * @return a collection of MetaData (or its subclass)
     */
    public Collection<T> getEntries();
    
}
