/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.io;

/**
 * This interface defines additional functionalities a web container can
 * provide for the response writer.  If implementated, perfermance will
 * likely to be improved.
 *
 * @author Kin-man Chung
 */
 
public interface ByteWriter {

    /**
     * Write a portion of a byte array to the output.
     *
     * @param  buff  A byte array
     * @param  off   Offset from which to start reading byte
     * @param  len   Number of bytes to write
     * @param  strlen If non-zero, the length of the string from which
     *               the bytes was converted.  If zero, then the string
     *               length is unknown.
     */
    void write(byte buff[], int off, int len, int strlen)
        throws java.io.IOException;
}
