/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mountcloud.graphql.request.GraphqlRequestType;
import org.mountcloud.graphql.request.mutation.GraphqlMutation;
import org.mountcloud.graphql.request.query.GraphqlQuery;
import org.mountcloud.graphql.response.DefaultGraphqlResponse;
import org.mountcloud.graphql.response.GraphqlResponse;
import org.mountcloud.graphql.util.HttpClientUtil;

public class GraphqlClient {
    private HttpClientUtil httpClientUtil = new HttpClientUtil();
    private String graphqlServerUrl = null;
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    private ObjectMapper objectMapper = new ObjectMapper();

    private GraphqlClient(String graphqlUrl) {
        this.graphqlServerUrl = graphqlUrl;
    }

    public static GraphqlClient buildGraphqlClient(String graphqlUrl) {
        GraphqlClient graphqlClient = new GraphqlClient(graphqlUrl);
        return graphqlClient;
    }

    public <T extends GraphqlQuery> GraphqlResponse doQuery(T query) throws IOException {
        return this.doQuery(query, GraphqlRequestType.POST);
    }

    public <T extends GraphqlQuery> GraphqlResponse doQuery(T query, GraphqlRequestType graphqlRequestType) throws IOException {
        String json = query.toString();
        String result = this.doHttpRequest(json, graphqlRequestType);
        if (result == null) {
            return null;
        }
        GraphqlResponse graphqlResponse = (GraphqlResponse)this.objectMapper.readValue(result, DefaultGraphqlResponse.class);
        return graphqlResponse;
    }

    public <T extends GraphqlMutation> GraphqlResponse doMutation(T mutation) throws IOException {
        return this.doMutation(mutation, GraphqlRequestType.POST);
    }

    public <T extends GraphqlMutation> GraphqlResponse doMutation(T mutation, GraphqlRequestType graphqlRequestType) throws IOException {
        String json = mutation.toString();
        String result = this.doHttpRequest(json, graphqlRequestType);
        if (result == null) {
            return null;
        }
        GraphqlResponse graphqlResponse = (GraphqlResponse)this.objectMapper.readValue(result, DefaultGraphqlResponse.class);
        return graphqlResponse;
    }

    private String doHttpRequest(String json, GraphqlRequestType type) throws IOException {
        String result = null;
        if (type.equals((Object)GraphqlRequestType.POST)) {
            result = this.httpClientUtil.doPostJson(this.graphqlServerUrl, json, this.httpHeaders);
        }
        return result;
    }

    public void setHttpHeaders(Map<String, String> headers) {
        this.httpHeaders = headers;
    }
}

