/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.graphql.request;

import java.util.ArrayList;
import java.util.List;
import org.mountcloud.graphql.request.param.RequestParameter;
import org.mountcloud.graphql.request.result.ResultAttributtes;

public abstract class GraphqlRequest {
    protected String requestName;
    protected RequestParameter requestParameter;
    protected List<ResultAttributtes> resultAttributes = new ArrayList<ResultAttributtes>();

    protected GraphqlRequest(String requestName) {
        this.requestName = requestName;
    }

    public RequestParameter addParameter(String key, Object val) {
        return this.getRequestParameter().addParameter(key, val);
    }

    public RequestParameter getRequestParameter() {
        if (this.requestParameter == null) {
            this.requestParameter = RequestParameter.build();
        }
        return this.requestParameter;
    }

    public GraphqlRequest addResultAttributes(String ... resultAttr) {
        if (resultAttr != null && resultAttr.length > 0) {
            for (String str : resultAttr) {
                ResultAttributtes ra = new ResultAttributtes(str);
                this.resultAttributes.add(ra);
            }
        }
        return this;
    }

    public GraphqlRequest addResultAttributes(ResultAttributtes ... resultAttr) {
        if (resultAttr != null && resultAttr.length > 0) {
            for (ResultAttributtes ra : resultAttr) {
                this.resultAttributes.add(ra);
            }
        }
        return this;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public String toString() {
        StringBuffer requestBuffer = new StringBuffer(this.requestName);
        String paramStr = this.getRequestParameter().toString();
        StringBuffer resultAttrBuffer = new StringBuffer("");
        boolean first = true;
        for (ResultAttributtes ra : this.resultAttributes) {
            if (first) {
                first = false;
            } else {
                resultAttrBuffer.append(" ");
            }
            resultAttrBuffer.append(ra.toString());
        }
        String resultAttrStr = resultAttrBuffer.toString();
        requestBuffer.append(paramStr);
        requestBuffer.append("{");
        requestBuffer.append(resultAttrStr);
        requestBuffer.append("}");
        return requestBuffer.toString();
    }
}

