/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.graphql.request.param;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import org.mountcloud.graphql.request.param.jsonserializer.EnumSerializer;

public class RequestObjectParameter {
    private ObjectMapper objectMapper = new ObjectMapper();
    private Object data;

    public RequestObjectParameter(Object data) {
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Enum.class, (JsonSerializer)new EnumSerializer());
        this.objectMapper.registerModule((Module)simpleModule);
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        String json = this.dataToJson();
        json = json.replaceAll("\\\"", "\\\\\"");
        return json;
    }

    private String dataToJson() {
        String str = "null";
        try {
            str = this.objectMapper.writeValueAsString(this.getData());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return str;
    }
}

