/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.graphql.request.param;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mountcloud.graphql.request.param.RequestObjectParameter;

public class RequestParameter
extends HashMap<String, Object> {
    private RequestParameter() {
    }

    public RequestParameter addParameter(String key, Object obj) {
        this.put(key, obj);
        return this;
    }

    public RequestParameter addObjectParameter(String key, Object obj) {
        if (obj instanceof RequestObjectParameter) {
            this.put(key, obj);
        } else {
            this.put(key, new RequestObjectParameter(obj));
        }
        return this;
    }

    public static RequestParameter buildByMap(Map map) {
        RequestParameter requestParameter = RequestParameter.build();
        requestParameter.putAll(map);
        return requestParameter;
    }

    public static RequestParameter build() {
        RequestParameter requestParameter = new RequestParameter();
        return requestParameter;
    }

    @Override
    public String toString() {
        Set keys = this.keySet();
        if (keys.size() == 0) {
            return "";
        }
        String stringVal = "(";
        char connect = ',';
        for (String key : keys) {
            stringVal = stringVal + key + ":" + this.packVal(this.get(key)) + connect;
        }
        char last = stringVal.charAt(stringVal.length() - 1);
        if (connect == last) {
            stringVal = stringVal.substring(0, stringVal.length() - 1);
        }
        stringVal = stringVal + ")";
        return stringVal;
    }

    private String packVal(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof Integer || val instanceof Boolean || val instanceof Float || val instanceof Double) {
            return String.valueOf(val);
        }
        if (val instanceof Enum) {
            Enum enumVal = (Enum)val;
            String enumName = enumVal.name();
            return enumName;
        }
        if (val instanceof RequestObjectParameter) {
            return val.toString();
        }
        return "\\\"" + String.valueOf(val) + "\\\"";
    }
}

