/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.retry;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import mousio.client.ConnectionState;
import mousio.client.retry.ConnectionFailHandler;
import mousio.client.retry.RetryHandler;

public abstract class RetryPolicy {
    private static final HashedWheelTimer timer = new HashedWheelTimer();
    protected int msBeforeRetry;

    public RetryPolicy(int msBeforeRetry) {
        this.msBeforeRetry = msBeforeRetry;
    }

    public void retry(final ConnectionState state, final RetryHandler retryHandler, final ConnectionFailHandler failHandler) {
        timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                RetryPolicy.this.retryAllUris(state, retryHandler, failHandler);
            }
        }, (long)this.getRetryTimeInMs(), TimeUnit.MILLISECONDS);
    }

    private void retryAllUris(ConnectionState state, RetryHandler retryHandler, ConnectionFailHandler failHandler) {
        IOException ex = null;
        for (int i = 0; i < state.uris.length; ++i) {
            URI uri = state.uris[i];
            try {
                state.uriIndex = i;
                retryHandler.doRetry();
                break;
            }
            catch (IOException e) {
                ex = e;
                continue;
            }
        }
        if (ex != null) {
            failHandler.catchException(ex);
        }
    }

    public int getRetryTimeInMs() {
        return this.msBeforeRetry;
    }

    public abstract boolean shouldRetry(ConnectionState var1);
}

