/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.requests;

import io.netty.handler.codec.http.HttpMethod;
import java.util.concurrent.TimeUnit;
import mousio.client.retry.RetryPolicy;
import mousio.etcd4j.requests.EtcdKeyRequest;
import mousio.etcd4j.transport.EtcdClientImpl;

public class EtcdKeyPutRequest
extends EtcdKeyRequest {
    public EtcdKeyPutRequest(EtcdClientImpl clientImpl, String key, RetryPolicy retryHandler) {
        super(clientImpl, HttpMethod.PUT, retryHandler);
        this.setKey(key);
    }

    public EtcdKeyPutRequest value(String value) {
        this.requestParams.put("value", value);
        return this;
    }

    public EtcdKeyPutRequest ttl(Integer ttl) {
        this.requestParams.put("ttl", ttl == null ? "" : ttl + "");
        return this;
    }

    public EtcdKeyPutRequest isDir() {
        this.requestParams.put("dir", "true");
        return this;
    }

    public EtcdKeyPutRequest prevExist() {
        this.requestParams.put("prevExist", "true");
        return this;
    }

    public EtcdKeyPutRequest prevIndex(long prevIndex) {
        this.requestParams.put("prevIndex", prevIndex + "");
        return this;
    }

    public EtcdKeyPutRequest prevValue(String value) {
        this.requestParams.put("prevValue", value);
        return this;
    }

    @Override
    public EtcdKeyPutRequest timeout(long timeout, TimeUnit unit) {
        super.timeout(timeout, unit);
        return this;
    }

    @Override
    public EtcdKeyPutRequest setRetryPolicy(RetryPolicy retryPolicy) {
        super.setRetryPolicy(retryPolicy);
        return this;
    }
}

