/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.retry;

import mousio.client.ConnectionState;
import mousio.client.retry.RetryPolicy;

public class RetryWithExponentialBackOff
extends RetryPolicy {
    private final int maxRetryCount;
    private final int maxDelay;
    protected int currentDelay = 0;

    public RetryWithExponentialBackOff(int startMsBeforeRetry) {
        this(startMsBeforeRetry, -1, -1);
    }

    @Override
    public int getRetryTimeInMs() {
        return this.currentDelay;
    }

    public RetryWithExponentialBackOff(int startMsBeforeRetry, int maxRetryCount, int maxDelay) {
        super(startMsBeforeRetry);
        this.maxRetryCount = maxRetryCount;
        this.maxDelay = maxDelay;
    }

    @Override
    public boolean shouldRetry(ConnectionState connectionState) {
        if (this.maxRetryCount != -1 && connectionState.retryCount >= this.maxRetryCount) {
            return false;
        }
        if (this.currentDelay == 0) {
            this.currentDelay = this.msBeforeRetry;
        } else if (this.maxDelay == -1) {
            this.currentDelay *= 2;
        } else if (this.currentDelay < this.maxDelay) {
            this.currentDelay *= 2;
            if (this.currentDelay > this.maxDelay) {
                this.currentDelay = this.maxDelay;
            }
        }
        return true;
    }
}

