/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.retry;

import mousio.client.ConnectionState;
import mousio.client.retry.RetryPolicy;

public class RetryWithExponentialBackOff
extends RetryPolicy {
    private final int maxRetryCount;
    private final int maxDelay;

    public RetryWithExponentialBackOff(int startMsBeforeRetry) {
        this(startMsBeforeRetry, -1, -1);
    }

    public RetryWithExponentialBackOff(int startMsBeforeRetry, int maxRetryCount, int maxDelay) {
        super(startMsBeforeRetry);
        this.maxRetryCount = maxRetryCount;
        this.maxDelay = maxDelay;
    }

    @Override
    public boolean shouldRetry(ConnectionState state) {
        if (this.maxRetryCount != -1 && state.retryCount >= this.maxRetryCount) {
            return false;
        }
        if (state.msBeforeRetry == 0) {
            state.msBeforeRetry = this.startRetryTime;
        } else if (this.maxDelay == -1) {
            state.msBeforeRetry *= 2;
        } else if (state.msBeforeRetry < this.maxDelay) {
            state.msBeforeRetry *= 2;
            if (state.msBeforeRetry > this.maxDelay) {
                state.msBeforeRetry = this.maxDelay;
            }
        }
        return true;
    }
}

