/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;

public class EtcdKeysResponseParser {
    private static final JsonFactory factory = new JsonFactory();
    private static final String ACTION = "action";
    private static final String NODE = "node";
    private static final String PREVNODE = "prevNode";
    private static final String KEY = "key";
    private static final String DIR = "dir";
    private static final String CREATEDINDEX = "createdIndex";
    private static final String MODIFIEDINDEX = "modifiedIndex";
    private static final String VALUE = "value";
    private static final String EXPIRATION = "expiration";
    private static final String TTL = "ttl";
    private static final String NODES = "nodes";
    private static final String CAUSE = "cause";
    private static final String ERRORCODE = "errorCode";
    private static final String MESSAGE = "message";
    private static final String INDEX = "index";

    public static EtcdKeysResponse parse(ByteBuf content) throws EtcdException, IOException {
        JsonParser parser = factory.createParser((InputStream)new ByteBufInputStream(content));
        if (parser.nextToken() == JsonToken.START_OBJECT) {
            if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().contentEquals(ACTION)) {
                return EtcdKeysResponseParser.parseResponse(parser);
            }
            throw EtcdKeysResponseParser.parseException(parser);
        }
        return null;
    }

    private static EtcdException parseException(JsonParser parser) throws IOException {
        EtcdException exception = new EtcdException();
        JsonToken token = parser.getCurrentToken();
        while (token != JsonToken.END_OBJECT && token != null) {
            switch (parser.getCurrentName()) {
                case "cause": {
                    exception.etcdCause = parser.nextTextValue();
                    break;
                }
                case "message": {
                    exception.etcdMessage = parser.nextTextValue();
                    break;
                }
                case "errorCode": {
                    exception.errorCode = parser.nextIntValue(0);
                    break;
                }
                case "index": {
                    exception.index = parser.nextIntValue(0);
                    break;
                }
                default: {
                    throw new JsonParseException("Unknown field in exception " + parser.getCurrentName(), parser.getCurrentLocation());
                }
            }
            token = parser.nextToken();
        }
        return exception;
    }

    private static EtcdKeysResponse parseResponse(JsonParser parser) throws IOException {
        String action = parser.nextTextValue();
        parser.nextToken();
        if (!parser.getCurrentName().contentEquals(NODE)) {
            throw new JsonParseException("Expecting 'node' as second field", parser.getCurrentLocation());
        }
        parser.nextToken();
        EtcdKeysResponse response = new EtcdKeysResponse(action, EtcdKeysResponseParser.parseNode(parser));
        JsonToken token = parser.nextToken();
        if (token == JsonToken.FIELD_NAME) {
            if (!parser.getCurrentName().contentEquals(PREVNODE)) {
                throw new JsonParseException("Expecting 'node' as second field", parser.getCurrentLocation());
            }
            parser.nextToken();
            response.prevNode = EtcdKeysResponseParser.parseNode(parser);
            token = parser.nextToken();
        }
        if (token == JsonToken.END_OBJECT) {
            return response;
        }
        throw new JsonParseException("Unexpected content after response " + token, parser.getCurrentLocation());
    }

    private static EtcdKeysResponse.EtcdNode parseNode(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("Expecting object at start of node description", parser.getCurrentLocation());
        }
        JsonToken token = parser.nextToken();
        EtcdKeysResponse.EtcdNode node = new EtcdKeysResponse.EtcdNode();
        while (token != JsonToken.END_OBJECT && token != null) {
            switch (parser.getCurrentName()) {
                case "key": {
                    node.key = parser.nextTextValue();
                    break;
                }
                case "createdIndex": {
                    node.createdIndex = parser.nextIntValue(0);
                    break;
                }
                case "modifiedIndex": {
                    node.modifiedIndex = parser.nextIntValue(0);
                    break;
                }
                case "value": {
                    node.value = parser.nextTextValue();
                    break;
                }
                case "dir": {
                    node.dir = parser.nextBooleanValue();
                    break;
                }
                case "expiration": {
                    node.expiration = ZonedDateTime.parse(parser.nextTextValue());
                    break;
                }
                case "ttl": {
                    node.ttl = parser.nextIntValue(0);
                    break;
                }
                case "nodes": {
                    parser.nextToken();
                    node.nodes = EtcdKeysResponseParser.parseNodes(parser);
                    break;
                }
                default: {
                    throw new JsonParseException("Unknown field " + parser.getCurrentName(), parser.getCurrentLocation());
                }
            }
            token = parser.nextToken();
        }
        return node;
    }

    private static List<EtcdKeysResponse.EtcdNode> parseNodes(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("Expecting an array of nodes", parser.getCurrentLocation());
        }
        ArrayList<EtcdKeysResponse.EtcdNode> nodes = new ArrayList<EtcdKeysResponse.EtcdNode>();
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_ARRAY && token != null) {
            nodes.add(EtcdKeysResponseParser.parseNode(parser));
            token = parser.nextToken();
        }
        return nodes;
    }
}

