/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.promises;

import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import mousio.etcd4j.responses.EtcdException;

public class EtcdResponsePromise<T> {
    protected Promise<T> promise;
    protected T response;
    protected Throwable exception;
    List<IsSimplePromiseResponseHandler<T>> handlers;
    private final GenericFutureListener<Promise<T>> promiseHandler = this::handlePromise;

    public void attachNettyPromise(Promise<T> promise) {
        promise.addListener(this.promiseHandler);
        if (this.promise != null) {
            this.promise.removeListener(this.promiseHandler);
            this.promise.cancel(true);
        }
        this.promise = promise;
    }

    public void addListener(IsSimplePromiseResponseHandler<T> listener) {
        if (this.handlers == null) {
            this.handlers = Arrays.asList(listener);
        } else {
            this.handlers.add(listener);
        }
    }

    public void removeListener(IsSimplePromiseResponseHandler<T> listener) {
        if (this.handlers != null) {
            this.handlers.remove(listener);
        }
    }

    protected void handlePromise(Promise<T> promise) {
        if (!promise.isSuccess()) {
            this.setException(promise.cause());
        } else {
            this.response = promise.getNow();
            if (this.handlers != null) {
                for (IsSimplePromiseResponseHandler<T> h : this.handlers) {
                    h.onResponse(this);
                }
            }
        }
    }

    public void setException(Throwable exception) {
        this.exception = exception;
        if (this.handlers != null) {
            for (IsSimplePromiseResponseHandler<T> h : this.handlers) {
                h.onResponse(this);
            }
        }
    }

    public T get() throws IOException, EtcdException, TimeoutException {
        if (!this.promise.isDone()) {
            Promise<T> listeningPromise = this.promise;
            listeningPromise.awaitUninterruptibly();
            if (listeningPromise != this.promise) {
                return this.get();
            }
            this.handlePromise(this.promise);
        }
        if (this.response != null) {
            return this.response;
        }
        if (this.exception instanceof EtcdException) {
            throw (EtcdException)this.exception;
        }
        if (this.exception instanceof IOException) {
            throw (IOException)this.exception;
        }
        if (this.exception instanceof io.netty.handler.timeout.TimeoutException) {
            throw new TimeoutException();
        }
        throw new IOException(this.exception);
    }

    public T getNow() {
        return this.response;
    }

    public Promise<T> getNettyPromise() {
        return this.promise;
    }

    public static interface IsSimplePromiseResponseHandler<T> {
        public void onResponse(EtcdResponsePromise<T> var1);
    }
}

