/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import mousio.client.ConnectionState;
import mousio.client.retry.RetryHandler;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.requests.EtcdKeyRequest;
import mousio.etcd4j.requests.EtcdRequest;
import mousio.etcd4j.requests.EtcdVersionRequest;
import mousio.etcd4j.transport.EtcdClientImpl;
import mousio.etcd4j.transport.EtcdKeyResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdNettyClient
implements EtcdClientImpl {
    private static final Logger logger = LoggerFactory.getLogger(EtcdNettyClient.class);
    private final Bootstrap bootstrap;
    private final NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    private final URI[] uris;
    protected int lastWorkingUriIndex = 0;

    public EtcdNettyClient(final SslContext sslContext, URI ... uri) {
        this.uris = uri;
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)300)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (sslContext != null) {
                    p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
                }
                p.addLast("codec", (ChannelHandler)new HttpClientCodec());
                p.addLast("aggregate", (ChannelHandler)new HttpObjectAggregator(102400));
            }
        });
    }

    @Override
    public <R> EtcdResponsePromise<R> send(final EtcdRequest<R> etcdRequest) throws IOException {
        final ConnectionState connectionState = new ConnectionState(this.uris);
        connectionState.uriIndex = this.lastWorkingUriIndex;
        if (etcdRequest.getPromise() == null) {
            EtcdResponsePromise responsePromise = new EtcdResponsePromise(etcdRequest.getRetryPolicy(), connectionState, new RetryHandler(){

                @Override
                public void doRetry() throws IOException {
                    EtcdNettyClient.this.connect(etcdRequest, connectionState);
                }
            });
            etcdRequest.setPromise(responsePromise);
        }
        connectionState.startTime = new Date().getTime();
        this.connect(etcdRequest, connectionState);
        return etcdRequest.getPromise();
    }

    protected <R> void connect(EtcdRequest<R> etcdRequest) throws IOException {
        this.connect(etcdRequest, etcdRequest.getPromise().getConnectionState());
    }

    protected <R> void connect(final EtcdRequest<R> etcdRequest, final ConnectionState connectionState) throws IOException {
        URI uri = this.uris[connectionState.uriIndex];
        String requestUrl = etcdRequest.getUrl();
        if (requestUrl.contains("://")) {
            uri = URI.create(requestUrl);
        }
        ChannelFuture connectFuture = this.bootstrap.clone().connect(uri.getHost(), uri.getPort());
        final Channel channel = connectFuture.channel();
        etcdRequest.getPromise().attachNettyPromise((Promise<R>)new DefaultPromise((EventExecutor)connectFuture.channel().eventLoop()));
        connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (!f.isSuccess()) {
                    etcdRequest.getPromise().handleRetry(f.cause());
                    return;
                }
                logger.info("Connected to " + channel.remoteAddress().toString());
                EtcdNettyClient.this.lastWorkingUriIndex = connectionState.uriIndex;
                EtcdNettyClient.this.modifyPipeLine(etcdRequest, f.channel().pipeline());
                HttpRequest httpRequest = EtcdNettyClient.createHttpRequest(etcdRequest.getUrl(), etcdRequest);
                channel.writeAndFlush((Object)httpRequest);
            }
        });
    }

    private <R> void modifyPipeLine(final EtcdRequest<R> req, ChannelPipeline pipeline) {
        if (req.getTimeout() != -1) {
            pipeline.addFirst(new ChannelHandler[]{new ReadTimeoutHandler((long)req.getTimeout(), req.getTimeoutUnit())});
        }
        if (req instanceof EtcdKeyRequest) {
            pipeline.addLast(new ChannelHandler[]{new EtcdKeyResponseHandler(this, (EtcdKeyRequest)req)});
        } else if (req instanceof EtcdVersionRequest) {
            pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<FullHttpResponse>(){

                protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
                    ((EtcdVersionRequest)req).getPromise().getNettyPromise().setSuccess((Object)msg.content().toString(Charset.defaultCharset()));
                }
            }});
        } else {
            throw new RuntimeException("Unknown request type " + req.getClass().getName());
        }
        pipeline.addLast(new ChannelHandler[]{new ChannelHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                req.getPromise().getNettyPromise().setFailure(cause);
            }
        }});
    }

    public static <R> HttpRequest createHttpRequest(String uri, EtcdRequest<R> etcdRequest) throws IOException {
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, etcdRequest.getMethod(), uri);
        httpRequest.headers().add("Connection", (Object)"keep-alive");
        try {
            httpRequest = EtcdNettyClient.setRequestParameters(uri, etcdRequest, (HttpRequest)httpRequest);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return httpRequest;
    }

    private static HttpRequest setRequestParameters(String uri, EtcdRequest<?> etcdRequest, HttpRequest httpRequest) throws Exception {
        Map<String, String> keyValuePairs = etcdRequest.getRequestParams();
        if (keyValuePairs != null && !keyValuePairs.isEmpty()) {
            if (etcdRequest.getMethod() == HttpMethod.POST) {
                HttpPostRequestEncoder bodyRequestEncoder = new HttpPostRequestEncoder(httpRequest, false);
                for (Map.Entry<String, String> entry : keyValuePairs.entrySet()) {
                    bodyRequestEncoder.addBodyAttribute(entry.getKey(), entry.getValue());
                }
                httpRequest = bodyRequestEncoder.finalizeRequest();
                bodyRequestEncoder.close();
            } else {
                String getLocation = "";
                for (Map.Entry<String, String> entry : keyValuePairs.entrySet()) {
                    if (!getLocation.isEmpty()) {
                        getLocation = getLocation + "&";
                    }
                    getLocation = getLocation + entry.getKey() + "=" + entry.getValue();
                }
                if (!uri.contains("?")) {
                    httpRequest.setUri(uri.concat("?").concat(getLocation));
                } else {
                    httpRequest.setUri(uri);
                }
            }
        }
        etcdRequest.setHttpRequest(httpRequest);
        return httpRequest;
    }

    @Override
    public void close() {
        this.eventLoopGroup.shutdownGracefully();
    }
}

