/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.retry;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import mousio.client.ConnectionState;
import mousio.client.retry.ConnectionFailHandler;
import mousio.client.retry.RetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(RetryPolicy.class);
    private static final HashedWheelTimer timer = new HashedWheelTimer();
    protected final int startRetryTime;

    public RetryPolicy(int startRetryTime) {
        this.startRetryTime = startRetryTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void retry(ConnectionState state, final RetryHandler retryHandler, final ConnectionFailHandler failHandler) throws RetryCancelled {
        if (state.retryCount == 0) {
            state.msBeforeRetry = this.startRetryTime;
        }
        ++state.uriIndex;
        if (state.uriIndex >= state.uris.length) {
            if (!this.shouldRetry(state)) throw new RetryCancelled();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Retry %s to send command", state.retryCount));
            }
            ++state.retryCount;
            state.uriIndex = 0;
            timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    try {
                        retryHandler.doRetry();
                    }
                    catch (IOException e) {
                        failHandler.catchException(e);
                    }
                }
            }, (long)state.msBeforeRetry, TimeUnit.MILLISECONDS);
            return;
        }
        try {
            retryHandler.doRetry();
            return;
        }
        catch (IOException e) {
            failHandler.catchException(e);
        }
    }

    public abstract boolean shouldRetry(ConnectionState var1);

    public static class RetryCancelled
    extends Exception {
        private static final long serialVersionUID = 8043829471264975062L;
    }
}

