/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.retry;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import mousio.client.ConnectionState;
import mousio.client.retry.ConnectionFailHandler;
import mousio.client.retry.RetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(RetryPolicy.class);
    protected final int startRetryTime;

    public RetryPolicy(int startRetryTime) {
        this.startRetryTime = startRetryTime;
    }

    public final void retry(final ConnectionState state, final RetryHandler retryHandler, final ConnectionFailHandler failHandler) throws RetryCancelled {
        if (state.retryCount == 0) {
            state.msBeforeRetry = this.startRetryTime;
        }
        ++state.retryCount;
        state.uriIndex = state.retryCount % state.uris.length;
        if (this.shouldRetry(state)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Retry {} to send command", (Object)state.retryCount);
            }
            if (state.msBeforeRetry > 0) {
                try {
                    state.timer.newTimeout(new TimerTask(){

                        public void run(Timeout timeout) throws Exception {
                            try {
                                retryHandler.doRetry(state);
                            }
                            catch (IOException e) {
                                failHandler.catchException(e);
                            }
                        }
                    }, (long)state.msBeforeRetry, TimeUnit.MILLISECONDS);
                }
                catch (IllegalStateException e) {
                    failHandler.catchException(new IOException(new CancellationException("Etcd client was closed")));
                }
            } else {
                try {
                    retryHandler.doRetry(state);
                }
                catch (IOException e) {
                    failHandler.catchException(e);
                }
            }
        } else {
            throw new RetryCancelled();
        }
    }

    public abstract boolean shouldRetry(ConnectionState var1);

    public static class RetryCancelled
    extends Exception {
        private static final long serialVersionUID = 8043829471264975062L;
    }
}

