/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.HashedWheelTimer;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.CancellationException;
import mousio.client.ConnectionState;
import mousio.client.retry.RetryHandler;
import mousio.etcd4j.EtcdSecurityContext;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.requests.EtcdRequest;
import mousio.etcd4j.transport.EtcdClientImpl;
import mousio.etcd4j.transport.EtcdNettyConfig;
import mousio.etcd4j.transport.EtcdResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdNettyClient
implements EtcdClientImpl {
    private static final Logger logger = LoggerFactory.getLogger(EtcdNettyClient.class);
    private static final int DEFAULT_PORT = 2379;
    private static final String ENV_ETCD4J_ENDPOINT = "ETCD4J_ENDPOINT";
    private final EventLoopGroup eventLoopGroup;
    private final URI[] uris;
    private final Bootstrap bootstrap;
    private final EtcdNettyConfig config;
    private final EtcdSecurityContext securityContext;
    private final HashedWheelTimer timer;
    protected volatile int lastWorkingUriIndex;

    public EtcdNettyClient(SslContext sslContext, URI ... uri) {
        this(new EtcdNettyConfig(), sslContext, uri);
    }

    public EtcdNettyClient(EtcdSecurityContext securityContext, URI ... uri) {
        this(new EtcdNettyConfig(), securityContext, uri);
    }

    public EtcdNettyClient(EtcdNettyConfig config, SslContext sslContext, URI ... uris) {
        this(config, new EtcdSecurityContext(sslContext), uris);
    }

    public EtcdNettyClient(EtcdNettyConfig config, URI ... uris) {
        this(config, EtcdSecurityContext.NONE, uris);
    }

    public EtcdNettyClient(final EtcdNettyConfig config, final EtcdSecurityContext securityContext, URI ... uris) {
        logger.info("Setting up Etcd4j Netty client");
        this.lastWorkingUriIndex = 0;
        this.config = config.clone();
        this.securityContext = securityContext.clone();
        this.uris = uris;
        this.timer = config.getTimer();
        this.eventLoopGroup = config.getEventLoopGroup();
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(config.getSocketChannelClass())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (securityContext.hasNettySsl()) {
                    p.addLast(new ChannelHandler[]{securityContext.nettySslContext().newHandler(ch.alloc())});
                } else if (securityContext.hasSsl()) {
                    p.addLast(new ChannelHandler[]{new SslHandler(securityContext.sslContext().createSSLEngine())});
                }
                p.addLast("codec", (ChannelHandler)new HttpClientCodec());
                if (securityContext.hasCredentials()) {
                    p.addLast("auth", (ChannelHandler)new HttpBasicAuthHandler());
                }
                p.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                p.addLast("aggregate", (ChannelHandler)new HttpObjectAggregator(config.getMaxFrameSize()));
            }
        });
    }

    protected Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Override
    public <R> EtcdResponsePromise<R> send(final EtcdRequest<R> etcdRequest) throws IOException {
        ConnectionState connectionState = new ConnectionState(this.timer, this.uris, this.lastWorkingUriIndex);
        if (etcdRequest.getPromise() == null) {
            etcdRequest.setPromise(new EtcdResponsePromise(etcdRequest.getRetryPolicy(), connectionState, new RetryHandler(){

                @Override
                public void doRetry(ConnectionState connectionState) throws IOException {
                    EtcdNettyClient.this.connect(etcdRequest, connectionState);
                }
            }));
        }
        this.connect(etcdRequest, connectionState);
        return etcdRequest.getPromise();
    }

    protected <R> void connect(EtcdRequest<R> etcdRequest) throws IOException {
        this.connect(etcdRequest, etcdRequest.getPromise().getConnectionState());
    }

    protected <R> void connect(final EtcdRequest<R> etcdRequest, final ConnectionState connectionState) throws IOException {
        URI uri;
        URI requestUri = URI.create(etcdRequest.getUrl());
        if (requestUri.getHost() != null && requestUri.getPort() > -1) {
            uri = requestUri;
        } else if (connectionState.uris.length == 0 && System.getenv(ENV_ETCD4J_ENDPOINT) != null) {
            String endpoint_uri = System.getenv(ENV_ETCD4J_ENDPOINT);
            if (logger.isDebugEnabled()) {
                logger.debug("Will use environment variable ETCD4J_ENDPOINT as uri with value " + endpoint_uri);
            }
            uri = URI.create(endpoint_uri);
        } else {
            uri = connectionState.uris[connectionState.uriIndex];
        }
        if (this.eventLoopGroup.isShuttingDown() || this.eventLoopGroup.isShutdown()) {
            etcdRequest.getPromise().getNettyPromise().cancel(true);
            if (logger.isDebugEnabled()) {
                logger.debug("Retry canceled because of closed etcd client");
            }
            return;
        }
        ChannelFuture connectFuture = uri.getPort() == -1 ? this.bootstrap.clone().connect(uri.getHost(), 2379) : this.bootstrap.clone().connect(uri.getHost(), uri.getPort());
        etcdRequest.getPromise().attachNettyPromise((Promise<R>)new DefaultPromise((EventExecutor)connectFuture.channel().eventLoop()));
        connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(final ChannelFuture f) throws Exception {
                if (!f.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Connection failed to {}", (Object)connectionState.uris[connectionState.uriIndex]);
                    }
                    if (f.cause() instanceof ClosedChannelException) {
                        etcdRequest.getPromise().cancel(new CancellationException("Channel closed"));
                    } else {
                        etcdRequest.getPromise().handleRetry(f.cause());
                    }
                    return;
                }
                if (etcdRequest.getPromise().getNettyPromise().isCancelled()) {
                    f.channel().close();
                    etcdRequest.getPromise().getNettyPromise().setFailure((Throwable)new CancellationException());
                    return;
                }
                final Promise listenedToPromise = etcdRequest.getPromise().getNettyPromise();
                listenedToPromise.addListener(new GenericFutureListener<Future<?>>(){

                    public void operationComplete(Future<?> future) throws Exception {
                        if (etcdRequest.getPromise().getNettyPromise() == listenedToPromise) {
                            f.channel().close();
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("Connected to {} ({})", (Object)f.channel().remoteAddress().toString(), (Object)connectionState.uriIndex);
                }
                EtcdNettyClient.this.lastWorkingUriIndex = connectionState.uriIndex;
                EtcdNettyClient.this.modifyPipeLine(etcdRequest, f.channel().pipeline());
                EtcdNettyClient.this.createAndSendHttpRequest(uri, etcdRequest.getUrl(), etcdRequest, f.channel()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            etcdRequest.getPromise().setException(future.cause());
                            f.channel().close();
                        }
                    }
                });
                f.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Connection closed for request {} on uri {} ", (Object)etcdRequest.getMethod().name(), (Object)etcdRequest.getUri());
                        }
                    }
                });
            }
        });
    }

    private <R> void modifyPipeLine(final EtcdRequest<R> req, ChannelPipeline pipeline) {
        final EtcdResponseHandler<R> handler = new EtcdResponseHandler<R>(this, req);
        if (req.hasTimeout()) {
            pipeline.addFirst(new ChannelHandler[]{new ReadTimeoutHandler(req.getTimeout(), req.getTimeoutUnit())});
        }
        pipeline.addLast(new ChannelHandler[]{handler});
        pipeline.addLast(new ChannelHandler[]{new ChannelHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                handler.retried(true);
                req.getPromise().handleRetry(cause);
            }
        }});
    }

    private <R> ChannelFuture createAndSendHttpRequest(URI server, String uri, EtcdRequest<R> etcdRequest, Channel channel) throws Exception {
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, etcdRequest.getMethod(), uri);
        httpRequest.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
        if (!this.config.hasHostName()) {
            httpRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)(server.getHost() + ":" + server.getPort()));
        } else {
            httpRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.config.getHostName());
        }
        HttpPostRequestEncoder bodyRequestEncoder = null;
        Map<String, String> keyValuePairs = etcdRequest.getRequestParams();
        if (keyValuePairs != null && !keyValuePairs.isEmpty()) {
            HttpMethod etcdRequestMethod = etcdRequest.getMethod();
            if (etcdRequestMethod == HttpMethod.POST || etcdRequestMethod == HttpMethod.PUT) {
                bodyRequestEncoder = new HttpPostRequestEncoder((HttpRequest)httpRequest, false);
                for (Map.Entry<String, String> entry : keyValuePairs.entrySet()) {
                    bodyRequestEncoder.addBodyAttribute(entry.getKey(), entry.getValue());
                }
                httpRequest = bodyRequestEncoder.finalizeRequest();
            } else {
                QueryStringEncoder encoder = new QueryStringEncoder(uri);
                for (Map.Entry<String, String> entry : keyValuePairs.entrySet()) {
                    encoder.addParam(entry.getKey(), entry.getValue());
                }
                httpRequest.setUri(encoder.toString());
            }
        }
        etcdRequest.setHttpRequest((HttpRequest)httpRequest);
        ChannelFuture future = channel.write((Object)httpRequest);
        if (bodyRequestEncoder != null && bodyRequestEncoder.isChunked()) {
            future = channel.write((Object)bodyRequestEncoder);
        }
        channel.flush();
        return future;
    }

    @Override
    public void close() {
        logger.info("Shutting down Etcd4j Netty client");
        if (this.config.isManagedEventLoopGroup()) {
            this.eventLoopGroup.shutdownGracefully();
        }
        if (this.config.isManagedTimer()) {
            this.timer.stop();
        }
    }

    private class HttpBasicAuthHandler
    extends ChannelOutboundHandlerAdapter {
        private HttpBasicAuthHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof HttpRequest) {
                this.addBasicAuthHeader((HttpRequest)msg);
            }
            ctx.write(msg, promise);
        }

        private void addBasicAuthHeader(HttpRequest request) {
            String auth = Base64.encode((ByteBuf)Unpooled.copiedBuffer((CharSequence)(EtcdNettyClient.this.securityContext.username() + ":" + EtcdNettyClient.this.securityContext.password()), (Charset)CharsetUtil.UTF_8)).toString(CharsetUtil.UTF_8);
            request.headers().add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("Basic " + auth));
        }
    }
}

