/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import mousio.etcd4j.EtcdUtil;
import mousio.etcd4j.responses.EtcdHeaderAwareResponse;
import mousio.etcd4j.responses.EtcdKeyAction;
import mousio.etcd4j.responses.EtcdResponseDecoder;
import mousio.etcd4j.responses.EtcdResponseDecoders;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class EtcdKeysResponse
implements EtcdHeaderAwareResponse {
    public static final EtcdResponseDecoder<EtcdKeysResponse> DECODER = EtcdResponseDecoders.json(EtcdKeysResponse.class);
    public final EtcdKeyAction action;
    public final EtcdNode node;
    public final EtcdNode prevNode;
    public String etcdClusterId;
    public Long etcdIndex;
    public Long raftIndex;
    public Long raftTerm;

    EtcdKeysResponse(@JsonProperty(value="action") String action, @JsonProperty(value="node") EtcdNode node, @JsonProperty(value="prevNode") EtcdNode prevNode) {
        this.action = EtcdKeyAction.valueOf(action);
        this.node = node;
        this.prevNode = prevNode;
        this.etcdClusterId = null;
        this.etcdIndex = null;
        this.raftIndex = null;
        this.raftTerm = null;
    }

    @Override
    public void loadHeaders(HttpHeaders headers) {
        if (headers != null) {
            this.etcdClusterId = headers.get("X-Etcd-Cluster-Id");
            this.etcdIndex = EtcdUtil.getHeaderPropertyAsLong(headers, "X-Etcd-Index");
            this.raftIndex = EtcdUtil.getHeaderPropertyAsLong(headers, "X-Raft-Index");
            this.raftTerm = EtcdUtil.getHeaderPropertyAsLong(headers, "X-Raft-Term");
        }
    }

    public EtcdKeyAction getAction() {
        return this.action;
    }

    public EtcdNode getNode() {
        return this.node;
    }

    public EtcdNode getPrevNode() {
        return this.prevNode;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class EtcdNode {
        public final String key;
        public final boolean dir;
        public final Long createdIndex;
        public final Long modifiedIndex;
        public final String value;
        public final Date expiration;
        public final Long ttl;
        public final List<EtcdNode> nodes;

        EtcdNode(@JsonProperty(value="dir") Boolean dir, @JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="createdIndex") long createdIndex, @JsonProperty(value="modifiedIndex") long modifiedIndex, @JsonProperty(value="expiration") String expiration, @JsonProperty(value="ttl") long ttl, @JsonProperty(value="nodes") List<EtcdNode> nodes) {
            this.dir = dir != null ? dir : false;
            this.key = key;
            this.value = value;
            this.createdIndex = createdIndex;
            this.modifiedIndex = modifiedIndex;
            this.ttl = ttl;
            this.nodes = nodes != null ? Collections.unmodifiableList(nodes) : Collections.unmodifiableList(Collections.emptyList());
            this.expiration = expiration != null ? EtcdUtil.convertDate(expiration) : null;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isDir() {
            return this.dir;
        }

        public Long getCreatedIndex() {
            return this.createdIndex;
        }

        public Long getModifiedIndex() {
            return this.modifiedIndex;
        }

        public String getValue() {
            return this.value;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public Long getTTL() {
            return this.ttl;
        }

        public List<EtcdNode> getNodes() {
            return this.nodes;
        }
    }
}

