/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.transport;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdNettyConfig
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(EtcdNettyConfig.class);
    private EventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    private boolean managedEventLoopGroup = true;
    private Class<? extends SocketChannel> socketChannelClass = NioSocketChannel.class;
    private int connectTimeout = 300;
    private int maxFrameSize = 102400;
    private String hostName;

    public EtcdNettyConfig() {
        String frameSize = System.getProperty("mousio.etcd4j.maxFrameSize");
        if (frameSize != null) {
            logger.warn("Setting mousio.etcd4j.maxFrameSize through system propery is deprecated. Please use the EtcdNettyConfig class");
            this.maxFrameSize = Integer.parseInt(frameSize);
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public EtcdNettyConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public EtcdNettyConfig setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return this.setEventLoopGroup(eventLoopGroup, true);
    }

    public EtcdNettyConfig setEventLoopGroup(EventLoopGroup eventLoopGroup, boolean managed) {
        if (this.managedEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully();
        }
        this.eventLoopGroup = eventLoopGroup;
        this.managedEventLoopGroup = managed;
        return this;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public boolean isManagedEventLoopGroup() {
        return this.managedEventLoopGroup;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public EtcdNettyConfig setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    public EtcdNettyConfig setSocketChannelClass(Class<? extends SocketChannel> socketChannelClass) {
        this.socketChannelClass = socketChannelClass;
        return this;
    }

    public boolean hasHostName() {
        return this.hostName != null && !this.hostName.trim().isEmpty();
    }

    public String getHostName() {
        return this.hostName;
    }

    public EtcdNettyConfig setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public EtcdNettyConfig clone() {
        try {
            return (EtcdNettyConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

