/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j;

import io.netty.handler.ssl.SslContext;
import javax.net.ssl.SSLContext;

public final class EtcdSecurityContext
implements Cloneable {
    public static final EtcdSecurityContext NONE = new EtcdSecurityContext(null, null, null, null);
    private final SSLContext sslContext;
    private final SslContext nettySslContext;
    private final String username;
    private final String password;

    public EtcdSecurityContext(SSLContext sslContext) {
        this(sslContext, null, null, null);
    }

    public EtcdSecurityContext(SslContext sslContext) {
        this(null, sslContext, null, null);
    }

    public EtcdSecurityContext(String username, String password) {
        this(null, null, username, password);
    }

    public EtcdSecurityContext(SslContext sslContext, String username, String password) {
        this(null, sslContext, username, password);
    }

    public EtcdSecurityContext(SSLContext sslContext, String username, String password) {
        this(sslContext, null, username, password);
    }

    private EtcdSecurityContext(SSLContext sslContext, SslContext nettySslContext, String username, String password) {
        this.sslContext = sslContext;
        this.nettySslContext = nettySslContext;
        this.username = username;
        this.password = password;
    }

    public SslContext nettySslContext() {
        return this.nettySslContext;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public boolean hasNettySsl() {
        return this.nettySslContext != null;
    }

    public boolean hasSsl() {
        return this.sslContext != null;
    }

    public boolean hasCredentials() {
        return this.username != null && !this.username.trim().isEmpty() && this.password != null && !this.password.trim().isEmpty();
    }

    public EtcdSecurityContext clone() {
        try {
            return (EtcdSecurityContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static EtcdSecurityContext withSslContext(SslContext sslContext) {
        return new EtcdSecurityContext(null, sslContext, null, null);
    }

    public static EtcdSecurityContext withSslContext(SSLContext sslContext) {
        return new EtcdSecurityContext(sslContext, null, null, null);
    }

    public static EtcdSecurityContext withCredential(String username, String password) {
        return new EtcdSecurityContext(null, null, username, password);
    }
}

