/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.retry;

import mousio.client.ConnectionState;
import mousio.client.retry.RetryPolicy;

public class RetryWithTimeout
extends RetryPolicy {
    private final long timeoutInMs;

    public RetryWithTimeout(int msBeforeRetry, int timeoutInMs) {
        super(msBeforeRetry);
        this.timeoutInMs = timeoutInMs;
        if (msBeforeRetry <= 0) {
            throw new IllegalArgumentException("RetryWithTimeout.msBeforeRetry must be > 0!");
        }
    }

    @Override
    public boolean shouldRetry(ConnectionState connectionState) {
        return System.currentTimeMillis() - connectionState.startTime < this.timeoutInMs;
    }
}

