/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.transport;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import mousio.etcd4j.requests.EtcdKeyRequest;
import mousio.etcd4j.responses.EtcdKeysResponse;
import mousio.etcd4j.responses.EtcdKeysResponseParser;
import mousio.etcd4j.transport.AbstractEtcdResponseHandler;
import mousio.etcd4j.transport.EtcdNettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdKeyResponseHandler
extends AbstractEtcdResponseHandler<EtcdKeyRequest, FullHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(EtcdKeyResponseHandler.class);

    public EtcdKeyResponseHandler(EtcdNettyClient etcdNettyClient, EtcdKeyRequest etcdKeyRequest) {
        super(etcdNettyClient, etcdKeyRequest);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Received " + response.status().code() + " for " + ((EtcdKeyRequest)this.request).getMethod().name() + " " + ((EtcdKeyRequest)this.request).getUri());
        }
        if (response.status().equals((Object)HttpResponseStatus.OK) || response.status().equals((Object)HttpResponseStatus.ACCEPTED) || response.status().equals((Object)HttpResponseStatus.CREATED)) {
            if (!response.content().isReadable()) {
                this.client.connect(this.request);
                return;
            }
            try {
                EtcdKeysResponse etcdKeysResponse = EtcdKeysResponseParser.parse(response.content());
                String etcdIndex = response.headers().get("X-Etcd-Index");
                if (etcdIndex != null) {
                    try {
                        etcdKeysResponse.etcdIndex = Long.parseLong(etcdIndex);
                    }
                    catch (Exception e) {
                        logger.error("could not parse X-Etcd-Index header", (Throwable)e);
                    }
                }
                this.promise.setSuccess((Object)etcdKeysResponse);
            }
            catch (Exception e) {
                this.promise.setFailure((Throwable)e);
            }
        } else if (response.status().equals((Object)HttpResponseStatus.MOVED_PERMANENTLY) || response.status().equals((Object)HttpResponseStatus.TEMPORARY_REDIRECT)) {
            if (response.headers().contains("Location")) {
                ((EtcdKeyRequest)this.request).setUrl(response.headers().get("Location"));
                this.client.connect(this.request);
                ctx.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("redirect for " + ((EtcdKeyRequest)this.request).getHttpRequest().uri() + " to " + response.headers().get("Location"));
                }
            } else {
                this.promise.setFailure((Throwable)new Exception("Missing Location header on redirect"));
            }
        } else {
            try {
                EtcdKeysResponse etcdKeysResponse = EtcdKeysResponseParser.parse(response.content());
                this.promise.setSuccess((Object)etcdKeysResponse);
            }
            catch (Exception e) {
                this.promise.setFailure((Throwable)e);
            }
        }
    }
}

