/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.transport;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdNettyConfig {
    private static final Logger logger = LoggerFactory.getLogger(EtcdNettyConfig.class);
    private EventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    private Class<? extends SocketChannel> socketChannelClass = NioSocketChannel.class;
    private int connectTimeout = 300;
    private int maxFrameSize = 102400;
    private String hostName;

    public EtcdNettyConfig() {
        String frameSize = System.getProperty("mousio.etcd4j.maxFrameSize");
        if (frameSize != null) {
            logger.warn("Setting mousio.etcd4j.maxFrameSize through system propery is deprecated. Please use the EtcdNettyConfig class");
            this.maxFrameSize = Integer.parseInt(frameSize);
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public EtcdNettyConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public EtcdNettyConfig setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public EtcdNettyConfig setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    public EtcdNettyConfig setSocketChannelClass(Class<? extends SocketChannel> socketChannelClass) {
        this.socketChannelClass = socketChannelClass;
        return this;
    }

    public String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Host could not be determined for local machine. Please configure one");
            }
        }
        return this.hostName;
    }

    public EtcdNettyConfig setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }
}

