/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part1.objectdescriptors;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BaseDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.Descriptor;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

@Descriptor(tags={20})
public class ProfileLevelIndicationDescriptor
extends BaseDescriptor {
    int profileLevelIndicationIndex;

    public ProfileLevelIndicationDescriptor() {
        this.tag = 20;
    }

    public void parseDetail(ByteBuffer bb) throws IOException {
        this.profileLevelIndicationIndex = IsoTypeReader.readUInt8(bb);
    }

    public ByteBuffer serialize() {
        ByteBuffer out = ByteBuffer.allocate(this.getSize());
        IsoTypeWriter.writeUInt8(out, 20);
        this.writeSize(out, this.getContentSize());
        IsoTypeWriter.writeUInt8(out, this.profileLevelIndicationIndex);
        return out;
    }

    public int getContentSize() {
        return 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProfileLevelIndicationDescriptor");
        sb.append("{profileLevelIndicationIndex=").append(Integer.toHexString(this.profileLevelIndicationIndex));
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileLevelIndicationDescriptor that = (ProfileLevelIndicationDescriptor)o;
        return this.profileLevelIndicationIndex == that.profileLevelIndicationIndex;
    }

    public int hashCode() {
        return this.profileLevelIndicationIndex;
    }
}

