/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.tools;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mp4parser.Box;
import org.mp4parser.Container;
import org.mp4parser.ParsableBox;
import org.mp4parser.support.AbstractContainerBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path {
    static Pattern component = Pattern.compile("(....|\\.\\.)(\\[(.*)\\])?");

    private Path() {
    }

    public static <T extends Box> T getPath(Box parsableBox, String path) {
        List<T> all = Path.getPaths(parsableBox, path, true);
        return (T)(all.isEmpty() ? null : (Box)all.get(0));
    }

    public static <T extends Box> T getPath(Container container, String path) {
        List<T> all = Path.getPaths(container, path, true);
        return (T)(all.isEmpty() ? null : (Box)all.get(0));
    }

    public static <T extends Box> T getPath(AbstractContainerBox containerBox, String path) {
        List<T> all = Path.getPaths(containerBox, path, true);
        return (T)(all.isEmpty() ? null : (Box)all.get(0));
    }

    public static <T extends Box> List<T> getPaths(Box box, String path) {
        return Path.getPaths(box, path, false);
    }

    public static <T extends Box> List<T> getPaths(Container container, String path) {
        return Path.getPaths(container, path, false);
    }

    private static <T extends Box> List<T> getPaths(AbstractContainerBox container, String path, boolean singleResult) {
        return Path.getPaths((Object)container, path, singleResult);
    }

    private static <T extends Box> List<T> getPaths(Container container, String path, boolean singleResult) {
        return Path.getPaths((Object)container, path, singleResult);
    }

    private static <T extends Box> List<T> getPaths(ParsableBox parsableBox, String path, boolean singleResult) {
        return Path.getPaths((Object)parsableBox, path, singleResult);
    }

    private static <T extends Box> List<T> getPaths(Object thing, String path, boolean singleResult) {
        String now;
        String later;
        if (path.startsWith("/")) {
            throw new RuntimeException("Cannot start at / - only relative path expression into the structure are allowed");
        }
        if (path.length() == 0) {
            if (thing instanceof ParsableBox) {
                return Collections.singletonList((Box)thing);
            }
            throw new RuntimeException("Result of path expression seems to be the root container. This is not allowed!");
        }
        if (path.contains("/")) {
            later = path.substring(path.indexOf(47) + 1);
            now = path.substring(0, path.indexOf(47));
        } else {
            now = path;
            later = "";
        }
        Matcher m = component.matcher(now);
        if (m.matches()) {
            String type = m.group(1);
            if ("..".equals(type)) {
                throw new RuntimeException(".. notation no longer allowed");
            }
            if (thing instanceof Container) {
                int index = -1;
                if (m.group(2) != null) {
                    String indexString = m.group(3);
                    index = Integer.parseInt(indexString);
                }
                LinkedList<T> children = new LinkedList<T>();
                int currentIndex = 0;
                for (Box box1 : ((Container)thing).getBoxes()) {
                    if (box1.getType().matches(type)) {
                        if (index == -1 || index == currentIndex) {
                            children.addAll(Path.getPaths(box1, later, singleResult));
                        }
                        ++currentIndex;
                    }
                    if (!singleResult && index < 0 || children.isEmpty()) continue;
                    return children;
                }
                return children;
            }
            return Collections.emptyList();
        }
        throw new RuntimeException(String.valueOf(now) + " is invalid path.");
    }

    public static boolean isContained(Container ref, Box box, String path) {
        return Path.getPaths(ref, path).contains(box);
    }
}

