/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.mp4parser.Box;
import org.mp4parser.Container;
import org.mp4parser.boxes.iso14496.part12.ChunkOffsetBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentBox;
import org.mp4parser.boxes.iso14496.part12.SampleAuxiliaryInformationOffsetsBox;
import org.mp4parser.boxes.iso14496.part12.SampleAuxiliaryInformationSizesBox;
import org.mp4parser.boxes.iso14496.part12.SchemeTypeBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBox;
import org.mp4parser.boxes.iso14496.part12.TrackRunBox;
import org.mp4parser.boxes.iso23001.part7.CencSampleAuxiliaryDataFormat;
import org.mp4parser.boxes.iso23001.part7.TrackEncryptionBox;
import org.mp4parser.muxer.Mp4TrackImpl;
import org.mp4parser.muxer.RandomAccessSource;
import org.mp4parser.muxer.tracks.CencEncryptedTrack;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.Path;

public class CencMp4TrackImplImpl
extends Mp4TrackImpl
implements CencEncryptedTrack {
    private List<CencSampleAuxiliaryDataFormat> sampleEncryptionEntries;
    private UUID defaultKeyId;

    public CencMp4TrackImplImpl(long trackId, Container isofile, RandomAccessSource randomAccess, String name) throws IOException {
        super(trackId, isofile, randomAccess, name);
        TrackBox trackBox = null;
        for (TrackBox box : Path.getPaths((Container)isofile, (String)"moov/trak")) {
            if (box.getTrackHeaderBox().getTrackId() != trackId) continue;
            trackBox = box;
            break;
        }
        SchemeTypeBox schm = (SchemeTypeBox)Path.getPath(trackBox, (String)"mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schm[0]");
        assert (schm != null && (schm.getSchemeType().equals("cenc") || schm.getSchemeType().equals("cbc1"))) : "Track must be CENC (cenc or cbc1) encrypted";
        this.sampleEncryptionEntries = new ArrayList<CencSampleAuxiliaryDataFormat>();
        List movieExtendsBoxes = Path.getPaths((Container)isofile, (String)"moov/mvex");
        if (!movieExtendsBoxes.isEmpty()) {
            for (MovieFragmentBox movieFragmentBox : isofile.getBoxes(MovieFragmentBox.class)) {
                List trafs = movieFragmentBox.getBoxes(TrackFragmentBox.class);
                for (TrackFragmentBox traf : trafs) {
                    long baseOffset;
                    if (traf.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
                    TrackEncryptionBox tenc = (TrackEncryptionBox)Path.getPath((AbstractContainerBox)trackBox, (String)"mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/tenc[0]");
                    assert (tenc != null);
                    this.defaultKeyId = tenc.getDefault_KID();
                    if (traf.getTrackFragmentHeaderBox().hasBaseDataOffset()) {
                        baseOffset = traf.getTrackFragmentHeaderBox().getBaseDataOffset();
                    } else {
                        Iterator it = isofile.getBoxes().iterator();
                        baseOffset = 0L;
                        Box b = (Box)it.next();
                        while (b != movieFragmentBox) {
                            baseOffset += b.getSize();
                            b = (Box)it.next();
                        }
                    }
                    FindSaioSaizPair saizSaioPair = new FindSaioSaizPair((Container)traf).invoke();
                    SampleAuxiliaryInformationOffsetsBox saio = saizSaioPair.getSaio();
                    SampleAuxiliaryInformationSizesBox saiz = saizSaioPair.getSaiz();
                    assert (saio != null);
                    long[] saioOffsets = saio.getOffsets();
                    assert (saioOffsets.length == traf.getBoxes(TrackRunBox.class).size());
                    assert (saiz != null);
                    List truns = traf.getBoxes(TrackRunBox.class);
                    int sampleNo = 0;
                    for (int i = 0; i < saioOffsets.length; ++i) {
                        int numSamples = ((TrackRunBox)truns.get(i)).getEntries().size();
                        long offset = saioOffsets[i];
                        long length = 0L;
                        for (int j = sampleNo; j < sampleNo + numSamples; ++j) {
                            length += (long)saiz.getSize(j);
                        }
                        ByteBuffer trunsCencSampleAuxData = randomAccess.get(baseOffset + offset, length);
                        for (int j = sampleNo; j < sampleNo + numSamples; ++j) {
                            short auxInfoSize = saiz.getSize(j);
                            this.sampleEncryptionEntries.add(this.parseCencAuxDataFormat(tenc.getDefaultIvSize(), trunsCencSampleAuxData, auxInfoSize));
                        }
                        sampleNo += numSamples;
                    }
                }
            }
        } else {
            TrackEncryptionBox tenc = (TrackEncryptionBox)Path.getPath((AbstractContainerBox)trackBox, (String)"mdia[0]/minf[0]/stbl[0]/stsd[0]/enc.[0]/sinf[0]/schi[0]/tenc[0]");
            assert (tenc != null);
            this.defaultKeyId = tenc.getDefault_KID();
            ChunkOffsetBox chunkOffsetBox = (ChunkOffsetBox)Path.getPath((AbstractContainerBox)trackBox, (String)"mdia[0]/minf[0]/stbl[0]/stco[0]");
            if (chunkOffsetBox == null) {
                chunkOffsetBox = (ChunkOffsetBox)Path.getPath((AbstractContainerBox)trackBox, (String)"mdia[0]/minf[0]/stbl[0]/co64[0]");
            }
            assert (trackBox != null);
            assert (chunkOffsetBox != null);
            long[] chunkSizes = trackBox.getSampleTableBox().getSampleToChunkBox().blowup(chunkOffsetBox.getChunkOffsets().length);
            FindSaioSaizPair saizSaioPair = new FindSaioSaizPair((Container)Path.getPath((AbstractContainerBox)trackBox, (String)"mdia[0]/minf[0]/stbl[0]")).invoke();
            SampleAuxiliaryInformationOffsetsBox saio = saizSaioPair.saio;
            SampleAuxiliaryInformationSizesBox saiz = saizSaioPair.saiz;
            if (saio.getOffsets().length == 1) {
                long offset = saio.getOffsets()[0];
                int sizeInTotal = 0;
                if (saiz.getDefaultSampleInfoSize() > 0) {
                    sizeInTotal += saiz.getSampleCount() * saiz.getDefaultSampleInfoSize();
                } else {
                    for (int i = 0; i < saiz.getSampleCount(); ++i) {
                        sizeInTotal += saiz.getSampleInfoSizes()[i];
                    }
                }
                ByteBuffer chunksCencSampleAuxData = randomAccess.get(offset, sizeInTotal);
                for (int i = 0; i < saiz.getSampleCount(); ++i) {
                    this.sampleEncryptionEntries.add(this.parseCencAuxDataFormat(tenc.getDefaultIvSize(), chunksCencSampleAuxData, saiz.getSize(i)));
                }
            } else if (saio.getOffsets().length == chunkSizes.length) {
                int currentSampleNo = 0;
                for (int i = 0; i < chunkSizes.length; ++i) {
                    long offset = saio.getOffsets()[i];
                    long size = 0L;
                    if (saiz.getDefaultSampleInfoSize() > 0) {
                        size += (long)saiz.getSampleCount() * chunkSizes[i];
                    } else {
                        int j = 0;
                        while ((long)j < chunkSizes[i]) {
                            size += (long)saiz.getSize(currentSampleNo + j);
                            ++j;
                        }
                    }
                    ByteBuffer chunksCencSampleAuxData = randomAccess.get(offset, size);
                    int j = 0;
                    while ((long)j < chunkSizes[i]) {
                        long auxInfoSize = saiz.getSize(currentSampleNo + j);
                        this.sampleEncryptionEntries.add(this.parseCencAuxDataFormat(tenc.getDefaultIvSize(), chunksCencSampleAuxData, auxInfoSize));
                        ++j;
                    }
                    currentSampleNo = (int)((long)currentSampleNo + chunkSizes[i]);
                }
            } else {
                throw new RuntimeException("Number of saio offsets must be either 1 or number of chunks");
            }
        }
    }

    private CencSampleAuxiliaryDataFormat parseCencAuxDataFormat(int ivSize, ByteBuffer chunksCencSampleAuxData, long auxInfoSize) {
        CencSampleAuxiliaryDataFormat cadf = new CencSampleAuxiliaryDataFormat();
        if (auxInfoSize > 0L) {
            cadf.iv = new byte[ivSize];
            chunksCencSampleAuxData.get(cadf.iv);
            if (auxInfoSize > (long)ivSize) {
                int numOfPairs = IsoTypeReader.readUInt16((ByteBuffer)chunksCencSampleAuxData);
                cadf.pairs = new CencSampleAuxiliaryDataFormat.Pair[numOfPairs];
                for (int i = 0; i < cadf.pairs.length; ++i) {
                    cadf.pairs[i] = cadf.createPair(IsoTypeReader.readUInt16((ByteBuffer)chunksCencSampleAuxData), IsoTypeReader.readUInt32((ByteBuffer)chunksCencSampleAuxData));
                }
            }
        }
        return cadf;
    }

    @Override
    public UUID getDefaultKeyId() {
        return this.defaultKeyId;
    }

    @Override
    public boolean hasSubSampleEncryption() {
        return false;
    }

    @Override
    public List<CencSampleAuxiliaryDataFormat> getSampleEncryptionEntries() {
        return this.sampleEncryptionEntries;
    }

    public String toString() {
        return "CencMp4TrackImpl{handler='" + this.getHandler() + '\'' + '}';
    }

    @Override
    public String getName() {
        return "enc(" + super.getName() + ")";
    }

    private class FindSaioSaizPair {
        private Container container;
        private SampleAuxiliaryInformationSizesBox saiz;
        private SampleAuxiliaryInformationOffsetsBox saio;

        public FindSaioSaizPair(Container container) {
            this.container = container;
        }

        public SampleAuxiliaryInformationSizesBox getSaiz() {
            return this.saiz;
        }

        public SampleAuxiliaryInformationOffsetsBox getSaio() {
            return this.saio;
        }

        public FindSaioSaizPair invoke() {
            List saizs = this.container.getBoxes(SampleAuxiliaryInformationSizesBox.class);
            List saios = this.container.getBoxes(SampleAuxiliaryInformationOffsetsBox.class);
            assert (saizs.size() == saios.size());
            this.saiz = null;
            this.saio = null;
            for (int i = 0; i < saizs.size(); ++i) {
                if (this.saiz == null && ((SampleAuxiliaryInformationSizesBox)saizs.get(i)).getAuxInfoType() == null || "cenc".equals(((SampleAuxiliaryInformationSizesBox)saizs.get(i)).getAuxInfoType())) {
                    this.saiz = (SampleAuxiliaryInformationSizesBox)saizs.get(i);
                } else if (this.saiz != null && this.saiz.getAuxInfoType() == null && "cenc".equals(((SampleAuxiliaryInformationSizesBox)saizs.get(i)).getAuxInfoType())) {
                    this.saiz = (SampleAuxiliaryInformationSizesBox)saizs.get(i);
                } else {
                    throw new RuntimeException("Are there two cenc labeled saiz?");
                }
                if (this.saio == null && ((SampleAuxiliaryInformationOffsetsBox)saios.get(i)).getAuxInfoType() == null || "cenc".equals(((SampleAuxiliaryInformationOffsetsBox)saios.get(i)).getAuxInfoType())) {
                    this.saio = (SampleAuxiliaryInformationOffsetsBox)saios.get(i);
                    continue;
                }
                if (this.saio != null && this.saio.getAuxInfoType() == null && "cenc".equals(((SampleAuxiliaryInformationOffsetsBox)saios.get(i)).getAuxInfoType())) {
                    this.saio = (SampleAuxiliaryInformationOffsetsBox)saios.get(i);
                    continue;
                }
                throw new RuntimeException("Are there two cenc labeled saio?");
            }
            return this;
        }
    }
}

