/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.muxer.Sample;
import org.mp4parser.tools.CastUtils;

public class SampleImpl
implements Sample {
    private final long offset;
    private final long size;
    private ByteBuffer[] data;

    public SampleImpl(ByteBuffer buf) {
        this.offset = -1L;
        this.size = buf.limit();
        this.data = new ByteBuffer[]{buf};
    }

    public SampleImpl(ByteBuffer[] data) {
        this.offset = -1L;
        int _size = 0;
        for (ByteBuffer byteBuffer : data) {
            _size += byteBuffer.remaining();
        }
        this.size = _size;
        this.data = data;
    }

    public SampleImpl(long offset, long sampleSize, ByteBuffer data) {
        this.offset = offset;
        this.size = sampleSize;
        this.data = new ByteBuffer[]{data};
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        for (ByteBuffer b : this.data) {
            channel.write(b.duplicate());
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        byte[] bCopy = new byte[CastUtils.l2i((long)this.size)];
        ByteBuffer copy = ByteBuffer.wrap(bCopy);
        for (ByteBuffer b : this.data) {
            copy.put(b.duplicate());
        }
        copy.rewind();
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SampleImpl");
        sb.append("{offset=").append(this.offset);
        sb.append("{size=").append(this.size);
        sb.append('}');
        return sb.toString();
    }
}

