/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.builder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mp4parser.BasicContainer;
import org.mp4parser.Box;
import org.mp4parser.Container;
import org.mp4parser.IsoFile;
import org.mp4parser.ParsableBox;
import org.mp4parser.boxes.iso14496.part12.ChunkOffsetBox;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.DataEntryUrlBox;
import org.mp4parser.boxes.iso14496.part12.DataInformationBox;
import org.mp4parser.boxes.iso14496.part12.DataReferenceBox;
import org.mp4parser.boxes.iso14496.part12.EditBox;
import org.mp4parser.boxes.iso14496.part12.EditListBox;
import org.mp4parser.boxes.iso14496.part12.FileTypeBox;
import org.mp4parser.boxes.iso14496.part12.HandlerBox;
import org.mp4parser.boxes.iso14496.part12.HintMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MediaBox;
import org.mp4parser.boxes.iso14496.part12.MediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MediaInformationBox;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.boxes.iso14496.part12.NullMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SampleAuxiliaryInformationOffsetsBox;
import org.mp4parser.boxes.iso14496.part12.SampleAuxiliaryInformationSizesBox;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleSizeBox;
import org.mp4parser.boxes.iso14496.part12.SampleTableBox;
import org.mp4parser.boxes.iso14496.part12.SampleToChunkBox;
import org.mp4parser.boxes.iso14496.part12.SoundMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.StaticChunkOffsetBox;
import org.mp4parser.boxes.iso14496.part12.SubtitleMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SyncSampleBox;
import org.mp4parser.boxes.iso14496.part12.TimeToSampleBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackHeaderBox;
import org.mp4parser.boxes.iso14496.part12.VideoMediaHeaderBox;
import org.mp4parser.boxes.iso23001.part7.CencSampleAuxiliaryDataFormat;
import org.mp4parser.boxes.iso23001.part7.SampleEncryptionBox;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox;
import org.mp4parser.boxes.samplegrouping.SampleToGroupBox;
import org.mp4parser.muxer.Edit;
import org.mp4parser.muxer.Movie;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.builder.Fragmenter;
import org.mp4parser.muxer.builder.Mp4Builder;
import org.mp4parser.muxer.builder.TimeBasedFragmenter;
import org.mp4parser.muxer.tracks.CencEncryptedTrack;
import org.mp4parser.support.Logger;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.Mp4Arrays;
import org.mp4parser.tools.Mp4Math;
import org.mp4parser.tools.Offsets;
import org.mp4parser.tools.Path;

public class DefaultMp4Builder
implements Mp4Builder {
    private static Logger LOG = Logger.getLogger(DefaultMp4Builder.class);
    Map<Track, StaticChunkOffsetBox> chunkOffsetBoxes = new HashMap<Track, StaticChunkOffsetBox>();
    Set<SampleAuxiliaryInformationOffsetsBox> sampleAuxiliaryInformationOffsetsBoxes = new HashSet<SampleAuxiliaryInformationOffsetsBox>();
    HashMap<Track, List<Sample>> track2Sample = new HashMap();
    HashMap<Track, long[]> track2SampleSizes = new HashMap();
    private Fragmenter fragmenter;

    private static long sum(int[] ls) {
        long rc = 0L;
        int[] nArray = ls;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray[i];
            rc += l;
        }
        return rc;
    }

    private static long sum(long[] ls) {
        long rc = 0L;
        for (long l : ls) {
            rc += l;
        }
        return rc;
    }

    public void setFragmenter(Fragmenter fragmenter) {
        this.fragmenter = fragmenter;
    }

    @Override
    public Container build(Movie movie) {
        if (this.fragmenter == null) {
            this.fragmenter = new TimeBasedFragmenter(2.0);
        }
        LOG.logDebug("Creating movie " + movie);
        for (Track track : movie.getTracks()) {
            List<Sample> samples = track.getSamples();
            this.putSamples(track, samples);
            long[] sizes = new long[samples.size()];
            for (int i = 0; i < sizes.length; ++i) {
                Sample b = (Sample)samples.get(i);
                sizes[i] = b.getSize();
            }
            this.track2SampleSizes.put(track, sizes);
        }
        BasicContainer isoFile = new BasicContainer();
        isoFile.addBox((Box)this.createFileTypeBox(movie));
        HashMap<Track, int[]> chunks = new HashMap<Track, int[]>();
        for (Track track : movie.getTracks()) {
            chunks.put(track, this.getChunkSizes(track));
        }
        MovieBox moov = this.createMovieBox(movie, chunks);
        isoFile.addBox((Box)moov);
        List stszs = Path.getPaths((Box)moov, (String)"trak/mdia/minf/stbl/stsz");
        long contentSize = 0L;
        for (SampleSizeBox stsz : stszs) {
            contentSize += DefaultMp4Builder.sum(stsz.getSampleSizes());
        }
        LOG.logDebug("About to create mdat");
        InterleaveChunkMdat mdat = new InterleaveChunkMdat(movie, chunks, contentSize);
        long dataOffset = 16L;
        for (Box lightBox : isoFile.getBoxes()) {
            dataOffset += lightBox.getSize();
        }
        isoFile.addBox((Box)mdat);
        LOG.logDebug("mdat crated");
        for (StaticChunkOffsetBox chunkOffsetBox : this.chunkOffsetBoxes.values()) {
            long[] offsets = chunkOffsetBox.getChunkOffsets();
            int i = 0;
            while (i < offsets.length) {
                int n = i++;
                offsets[n] = offsets[n] + dataOffset;
            }
        }
        for (SampleAuxiliaryInformationOffsetsBox saio : this.sampleAuxiliaryInformationOffsetsBoxes) {
            long offset = saio.getSize();
            offset += 44L;
            offset = Offsets.find((Container)isoFile, (ParsableBox)saio, (long)offset);
            long[] saioOffsets = saio.getOffsets();
            for (int i = 0; i < saioOffsets.length; ++i) {
                saioOffsets[i] = saioOffsets[i] + offset;
            }
            saio.setOffsets(saioOffsets);
        }
        return isoFile;
    }

    protected List<Sample> putSamples(Track track, List<Sample> samples) {
        return this.track2Sample.put(track, samples);
    }

    protected FileTypeBox createFileTypeBox(Movie movie) {
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("mp42");
        minorBrands.add("iso6");
        minorBrands.add("avc1");
        minorBrands.add("isom");
        return new FileTypeBox("iso6", 1L, minorBrands);
    }

    protected MovieBox createMovieBox(Movie movie, Map<Track, int[]> chunks) {
        MovieBox movieBox = new MovieBox();
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setCreationTime(new Date());
        mvhd.setModificationTime(new Date());
        mvhd.setMatrix(movie.getMatrix());
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration;
            if (track.getEdits() == null || track.getEdits().isEmpty()) {
                tracksDuration = track.getDuration() * movieTimeScale / track.getTrackMetaData().getTimescale();
            } else {
                double d = 0.0;
                for (Edit edit : track.getEdits()) {
                    d += (double)((long)edit.getSegmentDuration());
                }
                tracksDuration = (long)(d * (double)movieTimeScale);
            }
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        long nextTrackId = 0L;
        for (Track track : movie.getTracks()) {
            nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        mvhd.setNextTrackId(++nextTrackId);
        movieBox.addBox((Box)mvhd);
        for (Track track : movie.getTracks()) {
            movieBox.addBox((Box)this.createTrackBox(track, movie, chunks));
        }
        ParsableBox udta = this.createUdta(movie);
        if (udta != null) {
            movieBox.addBox((Box)udta);
        }
        return movieBox;
    }

    protected ParsableBox createUdta(Movie movie) {
        return null;
    }

    protected TrackBox createTrackBox(Track track, Movie movie, Map<Track, int[]> chunks) {
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox tkhd = new TrackHeaderBox();
        tkhd.setEnabled(true);
        tkhd.setInMovie(true);
        tkhd.setMatrix(track.getTrackMetaData().getMatrix());
        tkhd.setAlternateGroup(track.getTrackMetaData().getGroup());
        tkhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        if (track.getEdits() == null || track.getEdits().isEmpty()) {
            tkhd.setDuration(track.getDuration() * this.getTimescale(movie) / track.getTrackMetaData().getTimescale());
        } else {
            long d = 0L;
            for (Edit edit : track.getEdits()) {
                d += (long)edit.getSegmentDuration();
            }
            tkhd.setDuration(d * track.getTrackMetaData().getTimescale());
        }
        tkhd.setHeight(track.getTrackMetaData().getHeight());
        tkhd.setWidth(track.getTrackMetaData().getWidth());
        tkhd.setLayer(track.getTrackMetaData().getLayer());
        tkhd.setModificationTime(new Date());
        tkhd.setTrackId(track.getTrackMetaData().getTrackId());
        tkhd.setVolume(track.getTrackMetaData().getVolume());
        trackBox.addBox((Box)tkhd);
        trackBox.addBox((Box)this.createEdts(track, movie));
        MediaBox mdia = new MediaBox();
        trackBox.addBox((Box)mdia);
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        mdhd.setDuration(track.getDuration());
        mdhd.setTimescale(track.getTrackMetaData().getTimescale());
        mdhd.setLanguage(track.getTrackMetaData().getLanguage());
        mdia.addBox((Box)mdhd);
        HandlerBox hdlr = new HandlerBox();
        mdia.addBox((Box)hdlr);
        hdlr.setHandlerType(track.getHandler());
        MediaInformationBox minf = new MediaInformationBox();
        if (track.getHandler().equals("vide")) {
            minf.addBox((Box)new VideoMediaHeaderBox());
        } else if (track.getHandler().equals("soun")) {
            minf.addBox((Box)new SoundMediaHeaderBox());
        } else if (track.getHandler().equals("text")) {
            minf.addBox((Box)new NullMediaHeaderBox());
        } else if (track.getHandler().equals("subt")) {
            minf.addBox((Box)new SubtitleMediaHeaderBox());
        } else if (track.getHandler().equals("hint")) {
            minf.addBox((Box)new HintMediaHeaderBox());
        } else if (track.getHandler().equals("sbtl")) {
            minf.addBox((Box)new NullMediaHeaderBox());
        }
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox((Box)dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox((Box)url);
        minf.addBox((Box)dinf);
        ParsableBox stbl = this.createStbl(track, movie, chunks);
        minf.addBox((Box)stbl);
        mdia.addBox((Box)minf);
        LOG.logDebug("done with trak for track_" + track.getTrackMetaData().getTrackId());
        return trackBox;
    }

    protected ParsableBox createEdts(Track track, Movie movie) {
        if (track.getEdits() != null && track.getEdits().size() > 0) {
            EditListBox elst = new EditListBox();
            elst.setVersion(0);
            ArrayList<EditListBox.Entry> entries = new ArrayList<EditListBox.Entry>();
            for (Edit edit : track.getEdits()) {
                entries.add(new EditListBox.Entry(elst, Math.round(edit.getSegmentDuration() * (double)movie.getTimescale()), edit.getMediaTime() * track.getTrackMetaData().getTimescale() / edit.getTimeScale(), edit.getMediaRate()));
            }
            elst.setEntries(entries);
            EditBox edts = new EditBox();
            edts.addBox((Box)elst);
            return edts;
        }
        return null;
    }

    protected ParsableBox createStbl(Track track, Movie movie, Map<Track, int[]> chunks) {
        SampleTableBox stbl = new SampleTableBox();
        this.createStsd(track, stbl);
        this.createStts(track, stbl);
        this.createCtts(track, stbl);
        this.createStss(track, stbl);
        this.createSdtp(track, stbl);
        this.createStsc(track, chunks, stbl);
        this.createStsz(track, stbl);
        this.createStco(track, movie, chunks, stbl);
        HashMap<String, ArrayList<GroupEntry>> groupEntryFamilies = new HashMap<String, ArrayList<GroupEntry>>();
        for (Map.Entry<GroupEntry, long[]> entry : track.getSampleGroups().entrySet()) {
            String type = entry.getKey().getType();
            ArrayList<GroupEntry> groupEntries = (ArrayList<GroupEntry>)groupEntryFamilies.get(type);
            if (groupEntries == null) {
                groupEntries = new ArrayList<GroupEntry>();
                groupEntryFamilies.put(type, groupEntries);
            }
            groupEntries.add(entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : groupEntryFamilies.entrySet()) {
            SampleGroupDescriptionBox sgdb = new SampleGroupDescriptionBox();
            String type = (String)entry.getKey();
            sgdb.setGroupingType(type);
            sgdb.setGroupEntries((List)entry.getValue());
            SampleToGroupBox sbgp = new SampleToGroupBox();
            sbgp.setGroupingType(type);
            SampleToGroupBox.Entry last = null;
            for (int i = 0; i < track.getSamples().size(); ++i) {
                int index = 0;
                for (int j = 0; j < ((List)entry.getValue()).size(); ++j) {
                    GroupEntry groupEntry = (GroupEntry)((List)entry.getValue()).get(j);
                    long[] sampleNums = track.getSampleGroups().get(groupEntry);
                    if (Arrays.binarySearch(sampleNums, (long)i) < 0) continue;
                    index = j + 1;
                }
                if (last == null || last.getGroupDescriptionIndex() != index) {
                    last = new SampleToGroupBox.Entry(1L, index);
                    sbgp.getEntries().add(last);
                    continue;
                }
                last.setSampleCount(last.getSampleCount() + 1L);
            }
            stbl.addBox((Box)sgdb);
            stbl.addBox((Box)sbgp);
        }
        if (track instanceof CencEncryptedTrack) {
            this.createCencBoxes((CencEncryptedTrack)track, stbl, chunks.get(track));
        }
        this.createSubs(track, stbl);
        LOG.logDebug("done with stbl for track_" + track.getTrackMetaData().getTrackId());
        return stbl;
    }

    protected void createSubs(Track track, SampleTableBox stbl) {
        if (track.getSubsampleInformationBox() != null) {
            stbl.addBox((Box)track.getSubsampleInformationBox());
        }
    }

    protected void createCencBoxes(CencEncryptedTrack track, SampleTableBox stbl, int[] chunkSizes) {
        SampleAuxiliaryInformationSizesBox saiz = new SampleAuxiliaryInformationSizesBox();
        saiz.setAuxInfoType("cenc");
        saiz.setFlags(1);
        List<CencSampleAuxiliaryDataFormat> sampleEncryptionEntries = track.getSampleEncryptionEntries();
        if (track.hasSubSampleEncryption()) {
            short[] sizes = new short[sampleEncryptionEntries.size()];
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = (short)sampleEncryptionEntries.get(i).getSize();
            }
            saiz.setSampleInfoSizes(sizes);
        } else {
            saiz.setDefaultSampleInfoSize(8);
            saiz.setSampleCount(track.getSamples().size());
        }
        SampleAuxiliaryInformationOffsetsBox saio = new SampleAuxiliaryInformationOffsetsBox();
        SampleEncryptionBox senc = new SampleEncryptionBox();
        senc.setSubSampleEncryption(track.hasSubSampleEncryption());
        senc.setEntries(sampleEncryptionEntries);
        long offset = senc.getOffsetToFirstIV();
        int index = 0;
        long[] offsets = new long[chunkSizes.length];
        for (int i = 0; i < chunkSizes.length; ++i) {
            offsets[i] = offset;
            for (int j = 0; j < chunkSizes[i]; ++j) {
                offset += (long)sampleEncryptionEntries.get(index++).getSize();
            }
        }
        saio.setOffsets(offsets);
        stbl.addBox((Box)saiz);
        stbl.addBox((Box)saio);
        stbl.addBox((Box)senc);
        this.sampleAuxiliaryInformationOffsetsBoxes.add(saio);
    }

    protected void createStsd(Track track, SampleTableBox stbl) {
        stbl.addBox((Box)track.getSampleDescriptionBox());
    }

    protected void createStco(Track targetTrack, Movie movie, Map<Track, int[]> chunks, SampleTableBox stbl) {
        if (this.chunkOffsetBoxes.get(targetTrack) == null) {
            long offset = 0L;
            LOG.logDebug("Calculating chunk offsets for track_" + targetTrack.getTrackMetaData().getTrackId());
            ArrayList<Track> tracks = new ArrayList<Track>(chunks.keySet());
            Collections.sort(tracks, new Comparator<Track>(){

                @Override
                public int compare(Track o1, Track o2) {
                    return CastUtils.l2i((long)(o1.getTrackMetaData().getTrackId() - o2.getTrackMetaData().getTrackId()));
                }
            });
            HashMap<Track, Integer> trackToChunk = new HashMap<Track, Integer>();
            HashMap<Track, Integer> trackToSample = new HashMap<Track, Integer>();
            HashMap<Track, Double> trackToTime = new HashMap<Track, Double>();
            for (Track track : tracks) {
                trackToChunk.put(track, 0);
                trackToSample.put(track, 0);
                trackToTime.put(track, 0.0);
                this.chunkOffsetBoxes.put(track, new StaticChunkOffsetBox());
            }
            while (true) {
                Track nextChunksTrack = null;
                for (Track track : tracks) {
                    if (nextChunksTrack != null && !((Double)trackToTime.get(track) < (Double)trackToTime.get(nextChunksTrack)) || (Integer)trackToChunk.get(track) >= chunks.get(track).length) continue;
                    nextChunksTrack = track;
                }
                if (nextChunksTrack == null) break;
                ChunkOffsetBox chunkOffsetBox = (ChunkOffsetBox)this.chunkOffsetBoxes.get(nextChunksTrack);
                chunkOffsetBox.setChunkOffsets(Mp4Arrays.copyOfAndAppend((long[])chunkOffsetBox.getChunkOffsets(), (long[])new long[]{offset}));
                int nextChunksIndex = (Integer)trackToChunk.get(nextChunksTrack);
                int numberOfSampleInNextChunk = chunks.get(nextChunksTrack)[nextChunksIndex];
                int startSample = (Integer)trackToSample.get(nextChunksTrack);
                double time = (Double)trackToTime.get(nextChunksTrack);
                long[] durs = nextChunksTrack.getSampleDurations();
                for (int j = startSample; j < startSample + numberOfSampleInNextChunk; ++j) {
                    offset += this.track2SampleSizes.get(nextChunksTrack)[j];
                    time += (double)durs[j] / (double)nextChunksTrack.getTrackMetaData().getTimescale();
                }
                trackToChunk.put(nextChunksTrack, nextChunksIndex + 1);
                trackToSample.put(nextChunksTrack, startSample + numberOfSampleInNextChunk);
                trackToTime.put(nextChunksTrack, time);
            }
        }
        stbl.addBox((Box)this.chunkOffsetBoxes.get(targetTrack));
    }

    protected void createStsz(Track track, SampleTableBox stbl) {
        SampleSizeBox stsz = new SampleSizeBox();
        stsz.setSampleSizes(this.track2SampleSizes.get(track));
        stbl.addBox((Box)stsz);
    }

    protected void createStsc(Track track, Map<Track, int[]> chunks, SampleTableBox stbl) {
        int[] tracksChunkSizes = chunks.get(track);
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries(new LinkedList());
        long lastChunkSize = Integer.MIN_VALUE;
        for (int i = 0; i < tracksChunkSizes.length; ++i) {
            if (lastChunkSize == (long)tracksChunkSizes[i]) continue;
            stsc.getEntries().add(new SampleToChunkBox.Entry((long)(i + 1), (long)tracksChunkSizes[i], 1L));
            lastChunkSize = tracksChunkSizes[i];
        }
        stbl.addBox((Box)stsc);
    }

    protected void createSdtp(Track track, SampleTableBox stbl) {
        if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
            SampleDependencyTypeBox sdtp = new SampleDependencyTypeBox();
            sdtp.setEntries(track.getSampleDependencies());
            stbl.addBox((Box)sdtp);
        }
    }

    protected void createStss(Track track, SampleTableBox stbl) {
        long[] syncSamples = track.getSyncSamples();
        if (syncSamples != null && syncSamples.length > 0) {
            SyncSampleBox stss = new SyncSampleBox();
            stss.setSampleNumber(syncSamples);
            stbl.addBox((Box)stss);
        }
    }

    protected void createCtts(Track track, SampleTableBox stbl) {
        List<CompositionTimeToSample.Entry> compositionTimeToSampleEntries = track.getCompositionTimeEntries();
        if (compositionTimeToSampleEntries != null && !compositionTimeToSampleEntries.isEmpty()) {
            CompositionTimeToSample ctts = new CompositionTimeToSample();
            ctts.setEntries(compositionTimeToSampleEntries);
            stbl.addBox((Box)ctts);
        }
    }

    protected void createStts(Track track, SampleTableBox stbl) {
        TimeToSampleBox.Entry lastEntry = null;
        ArrayList<TimeToSampleBox.Entry> entries = new ArrayList<TimeToSampleBox.Entry>();
        for (long delta : track.getSampleDurations()) {
            if (lastEntry != null && lastEntry.getDelta() == delta) {
                lastEntry.setCount(lastEntry.getCount() + 1L);
                continue;
            }
            lastEntry = new TimeToSampleBox.Entry(1L, delta);
            entries.add(lastEntry);
        }
        TimeToSampleBox stts = new TimeToSampleBox();
        stts.setEntries(entries);
        stbl.addBox((Box)stts);
    }

    int[] getChunkSizes(Track track) {
        long[] referenceChunkStarts = this.fragmenter.sampleNumbers(track);
        int[] chunkSizes = new int[referenceChunkStarts.length];
        for (int i = 0; i < referenceChunkStarts.length; ++i) {
            long start = referenceChunkStarts[i] - 1L;
            long end = referenceChunkStarts.length == i + 1 ? (long)track.getSamples().size() : referenceChunkStarts[i + 1] - 1L;
            chunkSizes[i] = CastUtils.l2i((long)(end - start));
        }
        assert ((long)this.track2Sample.get(track).size() == DefaultMp4Builder.sum(chunkSizes)) : "The number of samples and the sum of all chunk lengths must be equal";
        return chunkSizes;
    }

    public long getTimescale(Movie movie) {
        long timescale = movie.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : movie.getTracks()) {
            timescale = Mp4Math.lcm((long)timescale, (long)track.getTrackMetaData().getTimescale());
        }
        return timescale;
    }

    private class InterleaveChunkMdat
    implements Box {
        List<Track> tracks;
        List<List<Sample>> chunkList = new ArrayList<List<Sample>>();
        long contentSize;

        private InterleaveChunkMdat(Movie movie, Map<Track, int[]> chunks, long contentSize) {
            this.contentSize = contentSize;
            this.tracks = movie.getTracks();
            ArrayList<Track> tracks = new ArrayList<Track>(chunks.keySet());
            Collections.sort(tracks, new Comparator<Track>(){

                @Override
                public int compare(Track o1, Track o2) {
                    return CastUtils.l2i((long)(o1.getTrackMetaData().getTrackId() - o2.getTrackMetaData().getTrackId()));
                }
            });
            HashMap<Track, Integer> trackToChunk = new HashMap<Track, Integer>();
            HashMap<Track, Integer> trackToSample = new HashMap<Track, Integer>();
            HashMap<Track, Double> trackToTime = new HashMap<Track, Double>();
            for (Track track : tracks) {
                trackToChunk.put(track, 0);
                trackToSample.put(track, 0);
                trackToTime.put(track, 0.0);
            }
            while (true) {
                Track nextChunksTrack = null;
                for (Track track : tracks) {
                    if (nextChunksTrack != null && !((Double)trackToTime.get(track) < (Double)trackToTime.get(nextChunksTrack)) || (Integer)trackToChunk.get(track) >= chunks.get(track).length) continue;
                    nextChunksTrack = track;
                }
                if (nextChunksTrack == null) break;
                int nextChunksIndex = (Integer)trackToChunk.get(nextChunksTrack);
                int numberOfSampleInNextChunk = chunks.get(nextChunksTrack)[nextChunksIndex];
                int startSample = (Integer)trackToSample.get(nextChunksTrack);
                double time = (Double)trackToTime.get(nextChunksTrack);
                for (int j = startSample; j < startSample + numberOfSampleInNextChunk; ++j) {
                    time += (double)nextChunksTrack.getSampleDurations()[j] / (double)nextChunksTrack.getTrackMetaData().getTimescale();
                }
                this.chunkList.add(nextChunksTrack.getSamples().subList(startSample, startSample + numberOfSampleInNextChunk));
                trackToChunk.put(nextChunksTrack, nextChunksIndex + 1);
                trackToSample.put(nextChunksTrack, startSample + numberOfSampleInNextChunk);
                trackToTime.put(nextChunksTrack, time);
            }
        }

        public String getType() {
            return "mdat";
        }

        public long getSize() {
            return 16L + this.contentSize;
        }

        private boolean isSmallBox(long contentSize) {
            return contentSize + 8L < 0x100000000L;
        }

        public void getBox(WritableByteChannel writableByteChannel) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(16);
            long size = this.getSize();
            if (this.isSmallBox(size)) {
                IsoTypeWriter.writeUInt32((ByteBuffer)bb, (long)size);
            } else {
                IsoTypeWriter.writeUInt32((ByteBuffer)bb, (long)1L);
            }
            bb.put(IsoFile.fourCCtoBytes((String)"mdat"));
            if (this.isSmallBox(size)) {
                bb.put(new byte[8]);
            } else {
                IsoTypeWriter.writeUInt64((ByteBuffer)bb, (long)size);
            }
            bb.rewind();
            writableByteChannel.write(bb);
            long writtenBytes = 0L;
            long writtenMegaBytes = 0L;
            LOG.logDebug("About to write " + this.contentSize);
            for (List<Sample> samples : this.chunkList) {
                for (Sample sample : samples) {
                    sample.writeTo(writableByteChannel);
                    if ((writtenBytes += sample.getSize()) <= 0x100000L) continue;
                    writtenBytes -= 0x100000L;
                    LOG.logDebug("Written " + ++writtenMegaBytes + "MB");
                }
            }
        }
    }
}

