/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.builder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mp4parser.BasicContainer;
import org.mp4parser.Box;
import org.mp4parser.Container;
import org.mp4parser.IsoFile;
import org.mp4parser.ParsableBox;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.DataEntryUrlBox;
import org.mp4parser.boxes.iso14496.part12.DataInformationBox;
import org.mp4parser.boxes.iso14496.part12.DataReferenceBox;
import org.mp4parser.boxes.iso14496.part12.EditBox;
import org.mp4parser.boxes.iso14496.part12.EditListBox;
import org.mp4parser.boxes.iso14496.part12.FileTypeBox;
import org.mp4parser.boxes.iso14496.part12.HandlerBox;
import org.mp4parser.boxes.iso14496.part12.HintMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MediaBox;
import org.mp4parser.boxes.iso14496.part12.MediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MediaInformationBox;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.MovieExtendsBox;
import org.mp4parser.boxes.iso14496.part12.MovieExtendsHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentRandomAccessBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentRandomAccessOffsetBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.boxes.iso14496.part12.NullMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SampleAuxiliaryInformationOffsetsBox;
import org.mp4parser.boxes.iso14496.part12.SampleAuxiliaryInformationSizesBox;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SampleFlags;
import org.mp4parser.boxes.iso14496.part12.SampleSizeBox;
import org.mp4parser.boxes.iso14496.part12.SampleTableBox;
import org.mp4parser.boxes.iso14496.part12.SampleToChunkBox;
import org.mp4parser.boxes.iso14496.part12.SchemeTypeBox;
import org.mp4parser.boxes.iso14496.part12.SoundMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.StaticChunkOffsetBox;
import org.mp4parser.boxes.iso14496.part12.SubtitleMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TimeToSampleBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackExtendsBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBaseMediaDecodeTimeBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox;
import org.mp4parser.boxes.iso14496.part12.TrackHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TrackRunBox;
import org.mp4parser.boxes.iso14496.part12.VideoMediaHeaderBox;
import org.mp4parser.boxes.iso23001.part7.CencSampleAuxiliaryDataFormat;
import org.mp4parser.boxes.iso23001.part7.SampleEncryptionBox;
import org.mp4parser.boxes.iso23001.part7.TrackEncryptionBox;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox;
import org.mp4parser.boxes.samplegrouping.SampleToGroupBox;
import org.mp4parser.muxer.Edit;
import org.mp4parser.muxer.Movie;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.builder.Fragmenter;
import org.mp4parser.muxer.builder.Mp4Builder;
import org.mp4parser.muxer.builder.TimeBasedFragmenter;
import org.mp4parser.muxer.tracks.CencEncryptedTrack;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.Path;

public class FragmentedMp4Builder
implements Mp4Builder {
    private static final Logger LOG = Logger.getLogger(FragmentedMp4Builder.class.getName());
    protected Fragmenter fragmenter;

    public Date getDate() {
        return new Date();
    }

    public ParsableBox createFtyp(Movie movie) {
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("mp42");
        minorBrands.add("iso6");
        minorBrands.add("avc1");
        minorBrands.add("isom");
        return new FileTypeBox("iso6", 1L, minorBrands);
    }

    protected List<Box> createMoofMdat(Movie movie) {
        ArrayList<Box> moofsMdats = new ArrayList<Box>();
        HashMap<Track, long[]> intersectionMap = new HashMap<Track, long[]>();
        HashMap<Track, Double> track2currentTime = new HashMap<Track, Double>();
        for (Track track : movie.getTracks()) {
            long[] intersects = this.fragmenter.sampleNumbers(track);
            intersectionMap.put(track, intersects);
            track2currentTime.put(track, 0.0);
        }
        int sequence = 1;
        while (!intersectionMap.isEmpty()) {
            Track earliestTrack = null;
            double earliestTime = Double.MAX_VALUE;
            for (Map.Entry trackEntry : track2currentTime.entrySet()) {
                if (!((Double)trackEntry.getValue() < earliestTime)) continue;
                earliestTime = (Double)trackEntry.getValue();
                earliestTrack = (Track)trackEntry.getKey();
            }
            assert (earliestTrack != null);
            long[] startSamples = (long[])intersectionMap.get(earliestTrack);
            long startSample = startSamples[0];
            long endSample = startSamples.length > 1 ? startSamples[1] : (long)(earliestTrack.getSamples().size() + 1);
            long[] times = earliestTrack.getSampleDurations();
            long timscale = earliestTrack.getTrackMetaData().getTimescale();
            for (long i = startSample; i < endSample; ++i) {
                earliestTime += (double)times[CastUtils.l2i((long)(i - 1L))] / (double)timscale;
            }
            this.createFragment(moofsMdats, earliestTrack, startSample, endSample, sequence);
            if (startSamples.length == 1) {
                intersectionMap.remove(earliestTrack);
                track2currentTime.remove(earliestTrack);
            } else {
                long[] nuStartSamples = new long[startSamples.length - 1];
                System.arraycopy(startSamples, 1, nuStartSamples, 0, nuStartSamples.length);
                intersectionMap.put(earliestTrack, nuStartSamples);
                track2currentTime.put(earliestTrack, earliestTime);
            }
            ++sequence;
        }
        return moofsMdats;
    }

    protected int createFragment(List<Box> moofsMdats, Track track, long startSample, long endSample, int sequence) {
        if (startSample != endSample) {
            moofsMdats.add((Box)this.createMoof(startSample, endSample, track, sequence));
            moofsMdats.add(this.createMdat(startSample, endSample, track, sequence));
        }
        return sequence;
    }

    @Override
    public Container build(Movie movie) {
        LOG.fine("Creating movie " + movie);
        if (this.fragmenter == null) {
            this.fragmenter = new TimeBasedFragmenter(2.0);
        }
        BasicContainer isoFile = new BasicContainer();
        isoFile.addBox((Box)this.createFtyp(movie));
        isoFile.addBox((Box)this.createMoov(movie));
        for (Box box : this.createMoofMdat(movie)) {
            isoFile.addBox(box);
        }
        isoFile.addBox((Box)this.createMfra(movie, (Container)isoFile));
        return isoFile;
    }

    protected Box createMdat(final long startSample, final long endSample, final Track track, int i) {
        class Mdat
        implements Box {
            long size_ = -1L;

            Mdat() {
            }

            public long getSize() {
                if (this.size_ != -1L) {
                    return this.size_;
                }
                long size = 8L;
                for (Sample sample : FragmentedMp4Builder.this.getSamples(startSample, endSample, track)) {
                    size += sample.getSize();
                }
                this.size_ = size;
                return size;
            }

            public String getType() {
                return "mdat";
            }

            public void getBox(WritableByteChannel writableByteChannel) throws IOException {
                ByteBuffer header = ByteBuffer.allocate(8);
                IsoTypeWriter.writeUInt32((ByteBuffer)header, (long)CastUtils.l2i((long)this.getSize()));
                header.put(IsoFile.fourCCtoBytes((String)this.getType()));
                header.rewind();
                writableByteChannel.write(header);
                List<Sample> samples = FragmentedMp4Builder.this.getSamples(startSample, endSample, track);
                for (Sample sample : samples) {
                    sample.writeTo(writableByteChannel);
                }
            }
        }
        return new Mdat();
    }

    protected void createTfhd(long startSample, long endSample, Track track, int sequenceNumber, TrackFragmentBox parent) {
        TrackFragmentHeaderBox tfhd = new TrackFragmentHeaderBox();
        SampleFlags sf = new SampleFlags();
        tfhd.setDefaultSampleFlags(sf);
        tfhd.setBaseDataOffset(-1L);
        tfhd.setTrackId(track.getTrackMetaData().getTrackId());
        tfhd.setDefaultBaseIsMoof(true);
        parent.addBox((Box)tfhd);
    }

    protected void createMfhd(long startSample, long endSample, Track track, int sequenceNumber, MovieFragmentBox parent) {
        MovieFragmentHeaderBox mfhd = new MovieFragmentHeaderBox();
        mfhd.setSequenceNumber((long)sequenceNumber);
        parent.addBox((Box)mfhd);
    }

    protected void createTraf(long startSample, long endSample, Track track, int sequenceNumber, MovieFragmentBox parent) {
        TrackFragmentBox traf = new TrackFragmentBox();
        parent.addBox((Box)traf);
        this.createTfhd(startSample, endSample, track, sequenceNumber, traf);
        this.createTfdt(startSample, track, traf);
        this.createTrun(startSample, endSample, track, sequenceNumber, traf);
        if (track instanceof CencEncryptedTrack) {
            this.createSaiz(startSample, endSample, (CencEncryptedTrack)track, sequenceNumber, traf);
            this.createSenc(startSample, endSample, (CencEncryptedTrack)track, sequenceNumber, traf);
            this.createSaio(startSample, endSample, (CencEncryptedTrack)track, sequenceNumber, traf, parent);
        }
        HashMap<String, ArrayList<GroupEntry>> groupEntryFamilies = new HashMap<String, ArrayList<GroupEntry>>();
        for (Map.Entry<GroupEntry, long[]> entry : track.getSampleGroups().entrySet()) {
            String type = entry.getKey().getType();
            ArrayList<GroupEntry> groupEntries = (ArrayList<GroupEntry>)groupEntryFamilies.get(type);
            if (groupEntries == null) {
                groupEntries = new ArrayList<GroupEntry>();
                groupEntryFamilies.put(type, groupEntries);
            }
            groupEntries.add(entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : groupEntryFamilies.entrySet()) {
            SampleGroupDescriptionBox sgpd = new SampleGroupDescriptionBox();
            String type = (String)entry.getKey();
            sgpd.setGroupEntries((List)entry.getValue());
            sgpd.setGroupingType(type);
            SampleToGroupBox sbgp = new SampleToGroupBox();
            sbgp.setGroupingType(type);
            SampleToGroupBox.Entry last = null;
            for (int i = CastUtils.l2i((long)(startSample - 1L)); i < CastUtils.l2i((long)(endSample - 1L)); ++i) {
                int index = 0;
                for (int j = 0; j < ((List)entry.getValue()).size(); ++j) {
                    GroupEntry groupEntry = (GroupEntry)((List)entry.getValue()).get(j);
                    long[] sampleNums = track.getSampleGroups().get(groupEntry);
                    if (Arrays.binarySearch(sampleNums, (long)i) < 0) continue;
                    index = j + 65537;
                }
                if (last == null || last.getGroupDescriptionIndex() != index) {
                    last = new SampleToGroupBox.Entry(1L, index);
                    sbgp.getEntries().add(last);
                    continue;
                }
                last.setSampleCount(last.getSampleCount() + 1L);
            }
            traf.addBox((Box)sgpd);
            traf.addBox((Box)sbgp);
        }
    }

    protected void createSenc(long startSample, long endSample, CencEncryptedTrack track, int sequenceNumber, TrackFragmentBox parent) {
        SampleEncryptionBox senc = new SampleEncryptionBox();
        senc.setSubSampleEncryption(track.hasSubSampleEncryption());
        senc.setEntries(track.getSampleEncryptionEntries().subList(CastUtils.l2i((long)(startSample - 1L)), CastUtils.l2i((long)(endSample - 1L))));
        parent.addBox((Box)senc);
    }

    protected void createSaio(long startSample, long endSample, CencEncryptedTrack track, int sequenceNumber, TrackFragmentBox parent, MovieFragmentBox moof) {
        Box box2;
        SchemeTypeBox schm = (SchemeTypeBox)Path.getPath((AbstractContainerBox)track.getSampleDescriptionBox(), (String)"enc.[0]/sinf[0]/schm[0]");
        SampleAuxiliaryInformationOffsetsBox saio = new SampleAuxiliaryInformationOffsetsBox();
        parent.addBox((Box)saio);
        assert (parent.getBoxes(TrackRunBox.class).size() == 1) : "Don't know how to deal with multiple Track Run Boxes when encrypting";
        saio.setAuxInfoType("cenc");
        saio.setFlags(1);
        long offset = 0L;
        offset += 8L;
        for (Box box2 : parent.getBoxes()) {
            if (box2 instanceof SampleEncryptionBox) {
                offset += (long)((SampleEncryptionBox)box2).getOffsetToFirstIV();
                break;
            }
            offset += box2.getSize();
        }
        offset += 16L;
        Iterator iterator = moof.getBoxes().iterator();
        while (iterator.hasNext() && (box2 = (Box)iterator.next()) != parent) {
            offset += box2.getSize();
        }
        saio.setOffsets(new long[]{offset});
    }

    protected void createSaiz(long startSample, long endSample, CencEncryptedTrack track, int sequenceNumber, TrackFragmentBox parent) {
        SampleDescriptionBox sampleDescriptionBox = track.getSampleDescriptionBox();
        TrackEncryptionBox tenc = (TrackEncryptionBox)Path.getPath((AbstractContainerBox)sampleDescriptionBox, (String)"enc.[0]/sinf[0]/schi[0]/tenc[0]");
        SampleAuxiliaryInformationSizesBox saiz = new SampleAuxiliaryInformationSizesBox();
        saiz.setAuxInfoType("cenc");
        saiz.setFlags(1);
        if (track.hasSubSampleEncryption()) {
            short[] sizes = new short[CastUtils.l2i((long)(endSample - startSample))];
            List<CencSampleAuxiliaryDataFormat> auxs = track.getSampleEncryptionEntries().subList(CastUtils.l2i((long)(startSample - 1L)), CastUtils.l2i((long)(endSample - 1L)));
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = (short)auxs.get(i).getSize();
            }
            saiz.setSampleInfoSizes(sizes);
        } else {
            assert (tenc != null);
            saiz.setDefaultSampleInfoSize(tenc.getDefaultIvSize());
            saiz.setSampleCount(CastUtils.l2i((long)(endSample - startSample)));
        }
        parent.addBox((Box)saiz);
    }

    protected List<Sample> getSamples(long startSample, long endSample, Track track) {
        return track.getSamples().subList(CastUtils.l2i((long)startSample) - 1, CastUtils.l2i((long)endSample) - 1);
    }

    protected long[] getSampleSizes(long startSample, long endSample, Track track, int sequenceNumber) {
        List<Sample> samples = this.getSamples(startSample, endSample, track);
        long[] sampleSizes = new long[samples.size()];
        for (int i = 0; i < sampleSizes.length; ++i) {
            sampleSizes[i] = samples.get(i).getSize();
        }
        return sampleSizes;
    }

    protected void createTfdt(long startSample, Track track, TrackFragmentBox parent) {
        TrackFragmentBaseMediaDecodeTimeBox tfdt = new TrackFragmentBaseMediaDecodeTimeBox();
        tfdt.setVersion(1);
        long startTime = 0L;
        long[] times = track.getSampleDurations();
        int i = 1;
        while ((long)i < startSample) {
            startTime += times[i - 1];
            ++i;
        }
        tfdt.setBaseMediaDecodeTime(startTime);
        parent.addBox((Box)tfdt);
    }

    protected void createTrun(long startSample, long endSample, Track track, int sequenceNumber, TrackFragmentBox parent) {
        TrackRunBox trun = new TrackRunBox();
        trun.setVersion(1);
        long[] sampleSizes = this.getSampleSizes(startSample, endSample, track, sequenceNumber);
        trun.setSampleDurationPresent(true);
        trun.setSampleSizePresent(true);
        ArrayList<TrackRunBox.Entry> entries = new ArrayList<TrackRunBox.Entry>(CastUtils.l2i((long)(endSample - startSample)));
        List<CompositionTimeToSample.Entry> compositionTimeEntries = track.getCompositionTimeEntries();
        int compositionTimeQueueIndex = 0;
        CompositionTimeToSample.Entry[] compositionTimeQueue = compositionTimeEntries != null && compositionTimeEntries.size() > 0 ? compositionTimeEntries.toArray(new CompositionTimeToSample.Entry[compositionTimeEntries.size()]) : null;
        long compositionTimeEntriesLeft = compositionTimeQueue != null ? (long)compositionTimeQueue[compositionTimeQueueIndex].getCount() : -1L;
        trun.setSampleCompositionTimeOffsetPresent(compositionTimeEntriesLeft > 0L);
        for (long i = 1L; i < startSample; ++i) {
            if (compositionTimeQueue == null || --compositionTimeEntriesLeft != 0L || compositionTimeQueue.length - compositionTimeQueueIndex <= 1) continue;
            compositionTimeEntriesLeft = compositionTimeQueue[++compositionTimeQueueIndex].getCount();
        }
        boolean sampleFlagsRequired = track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty() || track.getSyncSamples() != null && track.getSyncSamples().length != 0;
        trun.setSampleFlagsPresent(sampleFlagsRequired);
        for (int i = 0; i < sampleSizes.length; ++i) {
            TrackRunBox.Entry entry = new TrackRunBox.Entry();
            entry.setSampleSize(sampleSizes[i]);
            if (sampleFlagsRequired) {
                SampleFlags sflags = new SampleFlags();
                if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
                    SampleDependencyTypeBox.Entry e = track.getSampleDependencies().get(i);
                    sflags.setSampleDependsOn((int)e.getSampleDependsOn());
                    sflags.setSampleIsDependedOn((int)e.getSampleIsDependedOn());
                    sflags.setSampleHasRedundancy((int)e.getSampleHasRedundancy());
                }
                if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                    if (Arrays.binarySearch(track.getSyncSamples(), startSample + (long)i) >= 0) {
                        sflags.setSampleIsDifferenceSample(false);
                        sflags.setSampleDependsOn(2);
                    } else {
                        sflags.setSampleIsDifferenceSample(true);
                        sflags.setSampleDependsOn(1);
                    }
                }
                entry.setSampleFlags(sflags);
            }
            entry.setSampleDuration(track.getSampleDurations()[CastUtils.l2i((long)(startSample + (long)i - 1L))]);
            if (compositionTimeQueue != null) {
                entry.setSampleCompositionTimeOffset(compositionTimeQueue[compositionTimeQueueIndex].getOffset());
                if (--compositionTimeEntriesLeft == 0L && compositionTimeQueue.length - compositionTimeQueueIndex > 1) {
                    compositionTimeEntriesLeft = compositionTimeQueue[++compositionTimeQueueIndex].getCount();
                }
            }
            entries.add(entry);
        }
        trun.setEntries(entries);
        parent.addBox((Box)trun);
    }

    protected ParsableBox createMoof(long startSample, long endSample, Track track, int sequenceNumber) {
        MovieFragmentBox moof = new MovieFragmentBox();
        this.createMfhd(startSample, endSample, track, sequenceNumber, moof);
        this.createTraf(startSample, endSample, track, sequenceNumber, moof);
        TrackRunBox firstTrun = (TrackRunBox)moof.getTrackRunBoxes().get(0);
        firstTrun.setDataOffset(1);
        firstTrun.setDataOffset((int)(8L + moof.getSize()));
        return moof;
    }

    protected ParsableBox createMvhd(Movie movie) {
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setVersion(1);
        mvhd.setCreationTime(this.getDate());
        mvhd.setModificationTime(this.getDate());
        mvhd.setDuration(0L);
        long movieTimeScale = movie.getTimescale();
        mvhd.setTimescale(movieTimeScale);
        long nextTrackId = 0L;
        for (Track track : movie.getTracks()) {
            nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        mvhd.setNextTrackId(++nextTrackId);
        return mvhd;
    }

    protected ParsableBox createMoov(Movie movie) {
        MovieBox movieBox = new MovieBox();
        movieBox.addBox((Box)this.createMvhd(movie));
        for (Track track : movie.getTracks()) {
            movieBox.addBox((Box)this.createTrak(track, movie));
        }
        movieBox.addBox((Box)this.createMvex(movie));
        return movieBox;
    }

    protected Box createTfra(Track track, Container isoFile) {
        TrackFragmentRandomAccessBox tfra = new TrackFragmentRandomAccessBox();
        tfra.setVersion(1);
        LinkedList offset2timeEntries = new LinkedList();
        TrackExtendsBox trex = null;
        List trexs = Path.getPaths((Container)isoFile, (String)"moov/mvex/trex");
        for (TrackExtendsBox innerTrex : trexs) {
            if (innerTrex.getTrackId() != track.getTrackMetaData().getTrackId()) continue;
            trex = innerTrex;
        }
        long offset = 0L;
        long duration = 0L;
        for (Box box : isoFile.getBoxes()) {
            if (box instanceof MovieFragmentBox) {
                List trafs = ((MovieFragmentBox)box).getBoxes(TrackFragmentBox.class);
                for (int i = 0; i < trafs.size(); ++i) {
                    TrackFragmentBox traf = (TrackFragmentBox)trafs.get(i);
                    if (traf.getTrackFragmentHeaderBox().getTrackId() != track.getTrackMetaData().getTrackId()) continue;
                    List truns = traf.getBoxes(TrackRunBox.class);
                    for (int j = 0; j < truns.size(); ++j) {
                        LinkedList<TrackFragmentRandomAccessBox.Entry> offset2timeEntriesThisTrun = new LinkedList<TrackFragmentRandomAccessBox.Entry>();
                        TrackRunBox trun = (TrackRunBox)truns.get(j);
                        for (int k = 0; k < trun.getEntries().size(); ++k) {
                            TrackRunBox.Entry trunEntry = (TrackRunBox.Entry)trun.getEntries().get(k);
                            SampleFlags sf = k == 0 && trun.isFirstSampleFlagsPresent() ? trun.getFirstSampleFlags() : (trun.isSampleFlagsPresent() ? trunEntry.getSampleFlags() : trex.getDefaultSampleFlags());
                            if (sf == null && track.getHandler().equals("vide")) {
                                throw new RuntimeException("Cannot find SampleFlags for video track but it's required to build tfra");
                            }
                            if (sf == null || sf.getSampleDependsOn() == 2) {
                                offset2timeEntriesThisTrun.add(new TrackFragmentRandomAccessBox.Entry(duration, offset, (long)(i + 1), (long)(j + 1), (long)(k + 1)));
                            }
                            duration += trunEntry.getSampleDuration();
                        }
                        if (offset2timeEntriesThisTrun.size() == trun.getEntries().size() && trun.getEntries().size() > 0) {
                            offset2timeEntries.add(offset2timeEntriesThisTrun.get(0));
                            continue;
                        }
                        offset2timeEntries.addAll(offset2timeEntriesThisTrun);
                    }
                }
            }
            offset += box.getSize();
        }
        tfra.setEntries(offset2timeEntries);
        tfra.setTrackId(track.getTrackMetaData().getTrackId());
        return tfra;
    }

    protected ParsableBox createMfra(Movie movie, Container isoFile) {
        MovieFragmentRandomAccessBox mfra = new MovieFragmentRandomAccessBox();
        for (Track track : movie.getTracks()) {
            mfra.addBox(this.createTfra(track, isoFile));
        }
        MovieFragmentRandomAccessOffsetBox mfro = new MovieFragmentRandomAccessOffsetBox();
        mfra.addBox((Box)mfro);
        mfro.setMfraSize(mfra.getSize());
        return mfra;
    }

    protected ParsableBox createTrex(Movie movie, Track track) {
        TrackExtendsBox trex = new TrackExtendsBox();
        trex.setTrackId(track.getTrackMetaData().getTrackId());
        trex.setDefaultSampleDescriptionIndex(1L);
        trex.setDefaultSampleDuration(0L);
        trex.setDefaultSampleSize(0L);
        SampleFlags sf = new SampleFlags();
        if ("soun".equals(track.getHandler()) || "subt".equals(track.getHandler())) {
            sf.setSampleDependsOn(2);
            sf.setSampleIsDependedOn(2);
        }
        trex.setDefaultSampleFlags(sf);
        return trex;
    }

    protected ParsableBox createMvex(Movie movie) {
        MovieExtendsBox mvex = new MovieExtendsBox();
        MovieExtendsHeaderBox mved = new MovieExtendsHeaderBox();
        mved.setVersion(1);
        for (Track track : movie.getTracks()) {
            long trackDuration = this.getTrackDuration(movie, track);
            if (mved.getFragmentDuration() >= trackDuration) continue;
            mved.setFragmentDuration(trackDuration);
        }
        mvex.addBox((Box)mved);
        for (Track track : movie.getTracks()) {
            mvex.addBox((Box)this.createTrex(movie, track));
        }
        return mvex;
    }

    protected ParsableBox createTkhd(Movie movie, Track track) {
        TrackHeaderBox tkhd = new TrackHeaderBox();
        tkhd.setVersion(1);
        tkhd.setFlags(7);
        tkhd.setAlternateGroup(track.getTrackMetaData().getGroup());
        tkhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        tkhd.setDuration(0L);
        tkhd.setHeight(track.getTrackMetaData().getHeight());
        tkhd.setWidth(track.getTrackMetaData().getWidth());
        tkhd.setLayer(track.getTrackMetaData().getLayer());
        tkhd.setModificationTime(this.getDate());
        tkhd.setTrackId(track.getTrackMetaData().getTrackId());
        tkhd.setVolume(track.getTrackMetaData().getVolume());
        return tkhd;
    }

    private long getTrackDuration(Movie movie, Track track) {
        return track.getDuration() * movie.getTimescale() / track.getTrackMetaData().getTimescale();
    }

    protected ParsableBox createMdhd(Movie movie, Track track) {
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        mdhd.setModificationTime(this.getDate());
        mdhd.setDuration(0L);
        mdhd.setTimescale(track.getTrackMetaData().getTimescale());
        mdhd.setLanguage(track.getTrackMetaData().getLanguage());
        return mdhd;
    }

    protected ParsableBox createStbl(Movie movie, Track track) {
        SampleTableBox stbl = new SampleTableBox();
        this.createStsd(track, stbl);
        stbl.addBox((Box)new TimeToSampleBox());
        stbl.addBox((Box)new SampleToChunkBox());
        stbl.addBox((Box)new SampleSizeBox());
        stbl.addBox((Box)new StaticChunkOffsetBox());
        return stbl;
    }

    protected void createStsd(Track track, SampleTableBox stbl) {
        stbl.addBox((Box)track.getSampleDescriptionBox());
    }

    protected ParsableBox createMinf(Track track, Movie movie) {
        MediaInformationBox minf = new MediaInformationBox();
        if (track.getHandler().equals("vide")) {
            minf.addBox((Box)new VideoMediaHeaderBox());
        } else if (track.getHandler().equals("soun")) {
            minf.addBox((Box)new SoundMediaHeaderBox());
        } else if (track.getHandler().equals("text")) {
            minf.addBox((Box)new NullMediaHeaderBox());
        } else if (track.getHandler().equals("subt")) {
            minf.addBox((Box)new SubtitleMediaHeaderBox());
        } else if (track.getHandler().equals("hint")) {
            minf.addBox((Box)new HintMediaHeaderBox());
        } else if (track.getHandler().equals("sbtl")) {
            minf.addBox((Box)new NullMediaHeaderBox());
        }
        minf.addBox((Box)this.createDinf(movie, track));
        minf.addBox((Box)this.createStbl(movie, track));
        return minf;
    }

    protected ParsableBox createMdiaHdlr(Track track, Movie movie) {
        HandlerBox hdlr = new HandlerBox();
        hdlr.setHandlerType(track.getHandler());
        return hdlr;
    }

    protected ParsableBox createMdia(Track track, Movie movie) {
        MediaBox mdia = new MediaBox();
        mdia.addBox((Box)this.createMdhd(movie, track));
        mdia.addBox((Box)this.createMdiaHdlr(track, movie));
        mdia.addBox((Box)this.createMinf(track, movie));
        return mdia;
    }

    protected ParsableBox createTrak(Track track, Movie movie) {
        LOG.fine("Creating Track " + track);
        TrackBox trackBox = new TrackBox();
        trackBox.addBox((Box)this.createTkhd(movie, track));
        ParsableBox edts = this.createEdts(track, movie);
        if (edts != null) {
            trackBox.addBox((Box)edts);
        }
        trackBox.addBox((Box)this.createMdia(track, movie));
        return trackBox;
    }

    protected ParsableBox createEdts(Track track, Movie movie) {
        if (track.getEdits() != null && track.getEdits().size() > 0) {
            EditListBox elst = new EditListBox();
            elst.setVersion(1);
            ArrayList<EditListBox.Entry> entries = new ArrayList<EditListBox.Entry>();
            for (Edit edit : track.getEdits()) {
                entries.add(new EditListBox.Entry(elst, Math.round(edit.getSegmentDuration() * (double)movie.getTimescale()), edit.getMediaTime() * track.getTrackMetaData().getTimescale() / edit.getTimeScale(), edit.getMediaRate()));
            }
            elst.setEntries(entries);
            EditBox edts = new EditBox();
            edts.addBox((Box)elst);
            return edts;
        }
        return null;
    }

    protected DataInformationBox createDinf(Movie movie, Track track) {
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox((Box)dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox((Box)url);
        return dinf;
    }

    public Fragmenter getFragmenter() {
        return this.fragmenter;
    }

    public void setFragmenter(Fragmenter fragmenter) {
        this.fragmenter = fragmenter;
    }
}

