/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.builder;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.mp4parser.boxes.iso14496.part12.OriginalFormatBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.muxer.Movie;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.builder.Fragmenter;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.Mp4Math;
import org.mp4parser.tools.Path;

public class SyncSampleIntersectFinderImpl
implements Fragmenter {
    private static Logger LOG = Logger.getLogger(SyncSampleIntersectFinderImpl.class.getName());
    private final int minFragmentDurationSeconds;
    private Movie movie;
    private Track referenceTrack;

    public SyncSampleIntersectFinderImpl(Movie movie, Track referenceTrack, int minFragmentDurationSeconds) {
        this.movie = movie;
        this.referenceTrack = referenceTrack;
        this.minFragmentDurationSeconds = minFragmentDurationSeconds;
    }

    static String getFormat(Track track) {
        SampleDescriptionBox stsd = track.getSampleDescriptionBox();
        OriginalFormatBox frma = (OriginalFormatBox)Path.getPath((AbstractContainerBox)stsd, (String)"enc./sinf/frma");
        if (frma != null) {
            return frma.getDataFormat();
        }
        return stsd.getSampleEntry().getType();
    }

    public static List<long[]> getSyncSamplesTimestamps(Movie movie, Track track) {
        LinkedList<long[]> times = new LinkedList<long[]>();
        for (Track currentTrack : movie.getTracks()) {
            long[] currentTrackSyncSamples;
            if (!currentTrack.getHandler().equals(track.getHandler()) || (currentTrackSyncSamples = currentTrack.getSyncSamples()) == null || currentTrackSyncSamples.length <= 0) continue;
            long[] currentTrackTimes = SyncSampleIntersectFinderImpl.getTimes(currentTrack, movie);
            times.add(currentTrackTimes);
        }
        return times;
    }

    private static long[] getTimes(Track track, Movie m) {
        long[] syncSamples = track.getSyncSamples();
        long[] syncSampleTimes = new long[syncSamples.length];
        int currentSample = 1;
        long currentDuration = 0L;
        int currentSyncSampleIndex = 0;
        long scalingFactor = SyncSampleIntersectFinderImpl.calculateTracktimesScalingFactor(m, track);
        while ((long)currentSample <= syncSamples[syncSamples.length - 1]) {
            if ((long)currentSample == syncSamples[currentSyncSampleIndex]) {
                syncSampleTimes[currentSyncSampleIndex++] = currentDuration * scalingFactor;
            }
            currentDuration += track.getSampleDurations()[-1 + currentSample++];
        }
        return syncSampleTimes;
    }

    private static long calculateTracktimesScalingFactor(Movie m, Track track) {
        long timeScale = 1L;
        for (Track track1 : m.getTracks()) {
            if (!track1.getHandler().equals(track.getHandler()) || track1.getTrackMetaData().getTimescale() == track.getTrackMetaData().getTimescale()) continue;
            timeScale = Mp4Math.lcm((long)timeScale, (long)track1.getTrackMetaData().getTimescale());
        }
        return timeScale;
    }

    @Override
    public long[] sampleNumbers(Track track) {
        if ("vide".equals(track.getHandler())) {
            if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                List<long[]> times = SyncSampleIntersectFinderImpl.getSyncSamplesTimestamps(this.movie, track);
                return this.getCommonIndices(track.getSyncSamples(), SyncSampleIntersectFinderImpl.getTimes(track, this.movie), track.getTrackMetaData().getTimescale(), (long[][])times.toArray((T[])new long[times.size()][]));
            }
            throw new RuntimeException("Video Tracks need sync samples. Only tracks other than video may have no sync samples.");
        }
        if ("soun".equals(track.getHandler())) {
            if (this.referenceTrack == null) {
                for (Track candidate : this.movie.getTracks()) {
                    if (candidate.getSyncSamples() == null || !"vide".equals(candidate.getHandler()) || candidate.getSyncSamples().length <= 0) continue;
                    this.referenceTrack = candidate;
                }
            }
            if (this.referenceTrack != null) {
                long[] refSyncSamples = this.sampleNumbers(this.referenceTrack);
                int refSampleCount = this.referenceTrack.getSamples().size();
                long[] syncSamples = new long[refSyncSamples.length];
                long minSampleRate = 192000L;
                for (Track testTrack : this.movie.getTracks()) {
                    AudioSampleEntry ase;
                    if (!SyncSampleIntersectFinderImpl.getFormat(track).equals(SyncSampleIntersectFinderImpl.getFormat(testTrack)) || (ase = (AudioSampleEntry)testTrack.getSampleDescriptionBox().getSampleEntry()).getSampleRate() >= minSampleRate) continue;
                    minSampleRate = ase.getSampleRate();
                    long sc = testTrack.getSamples().size();
                    double stretch = (double)sc / (double)refSampleCount;
                    long samplesPerFrame = testTrack.getSampleDurations()[0];
                    for (int i = 0; i < syncSamples.length; ++i) {
                        long start;
                        syncSamples[i] = start = (long)Math.ceil(stretch * (double)(refSyncSamples[i] - 1L) * (double)samplesPerFrame);
                    }
                }
                AudioSampleEntry ase = (AudioSampleEntry)track.getSampleDescriptionBox().getSampleEntry();
                long samplesPerFrame = track.getSampleDurations()[0];
                double factor = (double)ase.getSampleRate() / (double)minSampleRate;
                if (factor != Math.rint(factor)) {
                    throw new RuntimeException("Sample rates must be a multiple of the lowest sample rate to create a correct file!");
                }
                for (int i = 0; i < syncSamples.length; ++i) {
                    syncSamples[i] = (long)(1.0 + (double)syncSamples[i] * factor / (double)samplesPerFrame);
                }
                return syncSamples;
            }
            throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
        }
        for (Track candidate : this.movie.getTracks()) {
            if (candidate.getSyncSamples() == null || candidate.getSyncSamples().length <= 0) continue;
            long[] refSyncSamples = this.sampleNumbers(candidate);
            int refSampleCount = candidate.getSamples().size();
            long[] syncSamples = new long[refSyncSamples.length];
            long sc = track.getSamples().size();
            double stretch = (double)sc / (double)refSampleCount;
            for (int i = 0; i < syncSamples.length; ++i) {
                long start;
                syncSamples[i] = start = (long)Math.ceil(stretch * (double)(refSyncSamples[i] - 1L)) + 1L;
            }
            return syncSamples;
        }
        throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
    }

    public long[] getCommonIndices(long[] syncSamples, long[] syncSampleTimes, long timeScale, long[] ... otherTracksTimes) {
        LinkedList<Long> nuSyncSamples = new LinkedList<Long>();
        LinkedList<Long> nuSyncSampleTimes = new LinkedList<Long>();
        for (int i = 0; i < syncSampleTimes.length; ++i) {
            boolean foundInEveryRef = true;
            long[][] lArray = otherTracksTimes;
            int n = lArray.length;
            for (int j = 0; j < n; ++j) {
                long[] times = lArray[j];
                foundInEveryRef &= Arrays.binarySearch(times, syncSampleTimes[i]) >= 0;
            }
            if (!foundInEveryRef) continue;
            nuSyncSamples.add(syncSamples[i]);
            nuSyncSampleTimes.add(syncSampleTimes[i]);
        }
        if ((double)nuSyncSamples.size() < (double)syncSamples.length * 0.25) {
            String log = "";
            log = log + String.format("%5d - Common:  [", nuSyncSamples.size());
            Iterator foundInEveryRef = nuSyncSamples.iterator();
            while (foundInEveryRef.hasNext()) {
                long l = (Long)foundInEveryRef.next();
                log = log + String.format("%10d,", l);
            }
            log = log + "]";
            LOG.warning(log);
            log = "";
            log = log + String.format("%5d - In    :  [", syncSamples.length);
            for (Object l : (Iterator)syncSamples) {
                log = log + String.format("%10d,", (long)l);
            }
            log = log + "]";
            LOG.warning(log);
            LOG.warning("There are less than 25% of common sync samples in the given track.");
            throw new RuntimeException("There are less than 25% of common sync samples in the given track.");
        }
        if ((double)nuSyncSamples.size() < (double)syncSamples.length * 0.5) {
            LOG.fine("There are less than 50% of common sync samples in the given track. This is implausible but I'm ok to continue.");
        } else if (nuSyncSamples.size() < syncSamples.length) {
            LOG.finest("Common SyncSample positions vs. this tracks SyncSample positions: " + nuSyncSamples.size() + " vs. " + syncSamples.length);
        }
        LinkedList<Long> finalSampleList = new LinkedList<Long>();
        if (this.minFragmentDurationSeconds > 0) {
            long lastSyncSampleTime = -1L;
            Iterator nuSyncSamplesIterator = nuSyncSamples.iterator();
            Iterator nuSyncSampleTimesIterator = nuSyncSampleTimes.iterator();
            while (nuSyncSamplesIterator.hasNext() && nuSyncSampleTimesIterator.hasNext()) {
                long curSyncSample = (Long)nuSyncSamplesIterator.next();
                long curSyncSampleTime = (Long)nuSyncSampleTimesIterator.next();
                if (lastSyncSampleTime != -1L && (curSyncSampleTime - lastSyncSampleTime) / timeScale < (long)this.minFragmentDurationSeconds) continue;
                finalSampleList.add(curSyncSample);
                lastSyncSampleTime = curSyncSampleTime;
            }
        } else {
            finalSampleList = nuSyncSamples;
        }
        long[] finalSampleArray = new long[finalSampleList.size()];
        for (int i = 0; i < finalSampleArray.length; ++i) {
            finalSampleArray[i] = (Long)finalSampleList.get(i);
        }
        return finalSampleArray;
    }
}

