/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.samples;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mp4parser.Box;
import org.mp4parser.Container;
import org.mp4parser.ParsableBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackExtendsBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TrackRunBox;
import org.mp4parser.muxer.RandomAccessSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.Offsets;
import org.mp4parser.tools.Path;

public class FragmentedMp4SampleList
extends AbstractList<Sample> {
    Container isofile;
    TrackBox trackBox = null;
    TrackExtendsBox trex = null;
    HashMap<TrackFragmentBox, MovieFragmentBox> traf2moof = new HashMap();
    private SoftReference<Sample>[] sampleCache;
    private List<TrackFragmentBox> allTrafs;
    private Map<TrackRunBox, SoftReference<ByteBuffer>> trunDataCache = new HashMap<TrackRunBox, SoftReference<ByteBuffer>>();
    private int[] firstSamples;
    private int size_ = -1;
    private RandomAccessSource randomAccess;

    public FragmentedMp4SampleList(long track, Container isofile, RandomAccessSource randomAccess) {
        this.isofile = isofile;
        this.randomAccess = randomAccess;
        List tbs = Path.getPaths((Container)isofile, (String)"moov[0]/trak");
        for (TrackBox tb : tbs) {
            if (tb.getTrackHeaderBox().getTrackId() != track) continue;
            this.trackBox = tb;
        }
        if (this.trackBox == null) {
            throw new RuntimeException("This MP4 does not contain track " + track);
        }
        List trexs = Path.getPaths((Container)isofile, (String)"moov[0]/mvex[0]/trex");
        for (TrackExtendsBox box : trexs) {
            if (box.getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
            this.trex = box;
        }
        this.sampleCache = (SoftReference[])Array.newInstance(SoftReference.class, this.size());
        this.initAllFragments();
    }

    private List<TrackFragmentBox> initAllFragments() {
        if (this.allTrafs != null) {
            return this.allTrafs;
        }
        ArrayList<TrackFragmentBox> trafs = new ArrayList<TrackFragmentBox>();
        for (MovieFragmentBox moof : this.isofile.getBoxes(MovieFragmentBox.class)) {
            for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                trafs.add(trackFragmentBox);
                this.traf2moof.put(trackFragmentBox, moof);
            }
        }
        this.allTrafs = trafs;
        int firstSample = 1;
        this.firstSamples = new int[this.allTrafs.size()];
        for (int i = 0; i < this.allTrafs.size(); ++i) {
            this.firstSamples[i] = firstSample;
            firstSample += this.getTrafSize(this.allTrafs.get(i));
        }
        return trafs;
    }

    private int getTrafSize(TrackFragmentBox traf) {
        List boxes = traf.getBoxes();
        int size = 0;
        for (Box b : boxes) {
            if (!(b instanceof TrackRunBox)) continue;
            size += CastUtils.l2i((long)((TrackRunBox)b).getSampleCount());
        }
        return size;
    }

    @Override
    public Sample get(int index) {
        Sample cachedSample;
        if (this.sampleCache[index] != null && (cachedSample = this.sampleCache[index].get()) != null) {
            return cachedSample;
        }
        int targetIndex = index + 1;
        int j = this.firstSamples.length - 1;
        while (targetIndex - this.firstSamples[j] < 0) {
            --j;
        }
        TrackFragmentBox trackFragmentBox = this.allTrafs.get(j);
        int sampleIndexWithInTraf = targetIndex - this.firstSamples[j];
        int previousTrunsSize = 0;
        MovieFragmentBox moof = this.traf2moof.get(trackFragmentBox);
        for (Box box : trackFragmentBox.getBoxes()) {
            SoftReference<ByteBuffer> trunDataRef;
            ByteBuffer trunData;
            if (!(box instanceof TrackRunBox)) continue;
            TrackRunBox trun = (TrackRunBox)box;
            if (trun.getEntries().size() <= sampleIndexWithInTraf - previousTrunsSize) {
                previousTrunsSize += trun.getEntries().size();
                continue;
            }
            List trackRunEntries = trun.getEntries();
            TrackFragmentHeaderBox tfhd = trackFragmentBox.getTrackFragmentHeaderBox();
            boolean sampleSizePresent = trun.isSampleSizePresent();
            boolean hasDefaultSampleSize = tfhd.hasDefaultSampleSize();
            long defaultSampleSize = 0L;
            if (!sampleSizePresent) {
                if (hasDefaultSampleSize) {
                    defaultSampleSize = tfhd.getDefaultSampleSize();
                } else {
                    if (this.trex == null) {
                        throw new RuntimeException("File doesn't contain trex box but track fragments aren't fully self contained. Cannot determine sample size.");
                    }
                    defaultSampleSize = this.trex.getDefaultSampleSize();
                }
            }
            ByteBuffer byteBuffer = trunData = (trunDataRef = this.trunDataCache.get(trun)) != null ? trunDataRef.get() : null;
            if (trunData == null) {
                long offset = 0L;
                if (tfhd.hasBaseDataOffset()) {
                    offset += tfhd.getBaseDataOffset();
                } else if (tfhd.isDefaultBaseIsMoof()) {
                    offset += Offsets.find((Container)this.isofile, (ParsableBox)moof, (long)0L);
                } else {
                    throw new RuntimeException("Rethink this case");
                }
                if (trun.isDataOffsetPresent()) {
                    offset += (long)trun.getDataOffset();
                }
                int size = 0;
                for (TrackRunBox.Entry e : trackRunEntries) {
                    if (sampleSizePresent) {
                        size = (int)((long)size + e.getSampleSize());
                        continue;
                    }
                    size = (int)((long)size + defaultSampleSize);
                }
                try {
                    trunData = this.randomAccess.get(offset, size);
                    this.trunDataCache.put(trun, new SoftReference<ByteBuffer>(trunData));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            int offset = 0;
            for (int i = 0; i < sampleIndexWithInTraf - previousTrunsSize; ++i) {
                offset = sampleSizePresent ? (int)((long)offset + ((TrackRunBox.Entry)trackRunEntries.get(i)).getSampleSize()) : (int)((long)offset + defaultSampleSize);
            }
            final long sampleSize = sampleSizePresent ? ((TrackRunBox.Entry)trackRunEntries.get(sampleIndexWithInTraf - previousTrunsSize)).getSampleSize() : defaultSampleSize;
            final ByteBuffer finalTrunData = trunData;
            final int finalOffset = offset;
            Sample sample = new Sample(){

                @Override
                public void writeTo(WritableByteChannel channel) throws IOException {
                    channel.write(this.asByteBuffer());
                }

                @Override
                public long getSize() {
                    return sampleSize;
                }

                @Override
                public ByteBuffer asByteBuffer() {
                    return (ByteBuffer)((ByteBuffer)finalTrunData.position(finalOffset)).slice().limit(CastUtils.l2i((long)sampleSize));
                }
            };
            this.sampleCache[index] = new SoftReference<1>(sample);
            return sample;
        }
        throw new RuntimeException("Couldn't find sample in the traf I was looking");
    }

    @Override
    public int size() {
        if (this.size_ != -1) {
            return this.size_;
        }
        int i = 0;
        for (MovieFragmentBox moof : this.isofile.getBoxes(MovieFragmentBox.class)) {
            for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                for (TrackRunBox trackRunBox : trackFragmentBox.getBoxes(TrackRunBox.class)) {
                    i = (int)((long)i + trackRunBox.getSampleCount());
                }
            }
        }
        this.size_ = i;
        return i;
    }
}

