/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.mp4parser.Container;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part15.AvcConfigurationBox;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.WrappingTrack;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.ByteBufferByteChannel;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeWriterVariable;
import org.mp4parser.tools.Path;

public class Avc1ToAvc3TrackImpl
extends WrappingTrack {
    SampleDescriptionBox stsd;
    AvcConfigurationBox avcC;
    List<Sample> samples;

    public Avc1ToAvc3TrackImpl(Track parent) throws IOException {
        super(parent);
        if (!"avc1".equals(parent.getSampleDescriptionBox().getSampleEntry().getType())) {
            throw new RuntimeException("Only avc1 tracks can be converted to avc3 tracks");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        parent.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
        IsoFile isoFile = new IsoFile((ReadableByteChannel)new ByteBufferByteChannel(ByteBuffer.wrap(baos.toByteArray())));
        this.stsd = (SampleDescriptionBox)Path.getPath((Container)isoFile, (String)"stsd");
        assert (this.stsd != null);
        ((VisualSampleEntry)this.stsd.getSampleEntry()).setType("avc3");
        this.avcC = (AvcConfigurationBox)Path.getPath((AbstractContainerBox)this.stsd, (String)"avc./avcC");
        this.samples = new ReplaceSyncSamplesList(parent.getSamples());
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    private class ReplaceSyncSamplesList
    extends AbstractList<Sample> {
        List<Sample> parentSamples;

        public ReplaceSyncSamplesList(List<Sample> parentSamples) {
            this.parentSamples = parentSamples;
        }

        @Override
        public Sample get(int index) {
            if (Arrays.binarySearch(Avc1ToAvc3TrackImpl.this.getSyncSamples(), (long)(index + 1)) >= 0) {
                final int len = Avc1ToAvc3TrackImpl.this.avcC.getLengthSizeMinusOne() + 1;
                final ByteBuffer buf = ByteBuffer.allocate(len);
                final Sample orignalSample = this.parentSamples.get(index);
                return new Sample(){

                    @Override
                    public void writeTo(WritableByteChannel channel) throws IOException {
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSets()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)((ByteBuffer)buf.rewind()), (int)len);
                            channel.write((ByteBuffer)buf.rewind());
                            channel.write(bytes);
                        }
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSetExts()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)((ByteBuffer)buf.rewind()), (int)len);
                            channel.write((ByteBuffer)buf.rewind());
                            channel.write(bytes);
                        }
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getPictureParameterSets()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)((ByteBuffer)buf.rewind()), (int)len);
                            channel.write((ByteBuffer)buf.rewind());
                            channel.write(bytes);
                        }
                        orignalSample.writeTo(channel);
                    }

                    @Override
                    public long getSize() {
                        int spsPpsSize = 0;
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSets()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSetExts()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getPictureParameterSets()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        return orignalSample.getSize() + (long)spsPpsSize;
                    }

                    @Override
                    public ByteBuffer asByteBuffer() {
                        int spsPpsSize = 0;
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSets()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSetExts()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getPictureParameterSets()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        ByteBuffer data = ByteBuffer.allocate(CastUtils.l2i((long)orignalSample.getSize()) + spsPpsSize);
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSets()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)data, (int)len);
                            data.put(bytes);
                        }
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSetExts()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)data, (int)len);
                            data.put(bytes);
                        }
                        for (ByteBuffer bytes : Avc1ToAvc3TrackImpl.this.avcC.getPictureParameterSets()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)data, (int)len);
                            data.put(bytes);
                        }
                        data.put(orignalSample.asByteBuffer());
                        return (ByteBuffer)data.rewind();
                    }
                };
            }
            return this.parentSamples.get(index);
        }

        @Override
        public int size() {
            return this.parentSamples.size();
        }
    }
}

