/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.mp4parser.Box;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.iso14496.part12.OriginalFormatBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SchemeTypeBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.boxes.samplegrouping.CencSampleEncryptionInformationGroupEntry;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.muxer.samples.CencDecryptingSampleList;
import org.mp4parser.muxer.tracks.CencEncryptedTrack;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.ByteBufferByteChannel;
import org.mp4parser.tools.Path;
import org.mp4parser.tools.RangeStartMap;

public class CencDecryptingTrackImpl
extends AbstractTrack {
    CencDecryptingSampleList samples;
    Track original;
    RangeStartMap<Integer, SecretKey> indexToKey = new RangeStartMap();

    public CencDecryptingTrackImpl(CencEncryptedTrack original, SecretKey sk) {
        this(original, Collections.singletonMap(original.getDefaultKeyId(), sk));
    }

    public CencDecryptingTrackImpl(CencEncryptedTrack original, Map<UUID, SecretKey> keys) {
        super("dec(" + original.getName() + ")");
        this.original = original;
        SchemeTypeBox schm = (SchemeTypeBox)Path.getPath((AbstractContainerBox)original.getSampleDescriptionBox(), (String)"enc./sinf/schm");
        assert (schm != null);
        if (!"cenc".equals(schm.getSchemeType()) && !"cbc1".equals(schm.getSchemeType())) {
            throw new RuntimeException("You can only use the CencDecryptingTrackImpl with CENC (cenc or cbc1) encrypted tracks");
        }
        ArrayList<CencSampleEncryptionInformationGroupEntry> groupEntries = new ArrayList<CencSampleEncryptionInformationGroupEntry>();
        for (Map.Entry<GroupEntry, long[]> groupEntry : original.getSampleGroups().entrySet()) {
            if (groupEntry.getKey() instanceof CencSampleEncryptionInformationGroupEntry) {
                groupEntries.add((CencSampleEncryptionInformationGroupEntry)groupEntry.getKey());
                continue;
            }
            this.getSampleGroups().put(groupEntry.getKey(), groupEntry.getValue());
        }
        int lastSampleGroupDescriptionIndex = -1;
        for (int i = 0; i < original.getSamples().size(); ++i) {
            int index = 0;
            for (int j = 0; j < groupEntries.size(); ++j) {
                GroupEntry groupEntry = (GroupEntry)groupEntries.get(j);
                long[] sampleNums = original.getSampleGroups().get(groupEntry);
                if (Arrays.binarySearch(sampleNums, (long)i) < 0) continue;
                index = j + 1;
            }
            if (lastSampleGroupDescriptionIndex == index) continue;
            if (index == 0) {
                this.indexToKey.put((Comparable)Integer.valueOf(i), (Object)keys.get(original.getDefaultKeyId()));
            } else if (((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).isEncrypted()) {
                SecretKey sk = keys.get(((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid());
                if (sk == null) {
                    throw new RuntimeException("Key " + ((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid() + " was not supplied for decryption");
                }
                this.indexToKey.put((Comparable)Integer.valueOf(i), (Object)sk);
            } else {
                this.indexToKey.put((Comparable)Integer.valueOf(i), null);
            }
            lastSampleGroupDescriptionIndex = index;
        }
        this.samples = new CencDecryptingSampleList(this.indexToKey, original.getSamples(), original.getSampleEncryptionEntries(), schm.getSchemeType());
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    @Override
    public long[] getSyncSamples() {
        return this.original.getSyncSamples();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        SampleDescriptionBox stsd;
        OriginalFormatBox frma = (OriginalFormatBox)Path.getPath((AbstractContainerBox)this.original.getSampleDescriptionBox(), (String)"enc./sinf/frma");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.original.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
            stsd = (SampleDescriptionBox)new IsoFile((ReadableByteChannel)new ByteBufferByteChannel(ByteBuffer.wrap(baos.toByteArray()))).getBoxes().get(0);
        }
        catch (IOException e) {
            throw new RuntimeException("Dumping stsd to memory failed");
        }
        if (stsd.getSampleEntry() instanceof AudioSampleEntry) {
            ((AudioSampleEntry)stsd.getSampleEntry()).setType(frma.getDataFormat());
        } else if (stsd.getSampleEntry() instanceof VisualSampleEntry) {
            ((VisualSampleEntry)stsd.getSampleEntry()).setType(frma.getDataFormat());
        } else {
            throw new RuntimeException("I don't know " + stsd.getSampleEntry().getType());
        }
        LinkedList<Box> nuBoxes = new LinkedList<Box>();
        for (Box box : stsd.getSampleEntry().getBoxes()) {
            if (box.getType().equals("sinf")) continue;
            nuBoxes.add(box);
        }
        stsd.getSampleEntry().setBoxes(nuBoxes);
        return stsd;
    }

    @Override
    public long[] getSampleDurations() {
        return this.original.getSampleDurations();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.original.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.original.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }
}

