/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.mp4parser.Box;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.OriginalFormatBox;
import org.mp4parser.boxes.iso14496.part12.ProtectionSchemeInformationBox;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SchemeInformationBox;
import org.mp4parser.boxes.iso14496.part12.SchemeTypeBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.iso14496.part15.AvcConfigurationBox;
import org.mp4parser.boxes.iso14496.part15.HevcConfigurationBox;
import org.mp4parser.boxes.iso23001.part7.CencSampleAuxiliaryDataFormat;
import org.mp4parser.boxes.iso23001.part7.TrackEncryptionBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.boxes.samplegrouping.CencSampleEncryptionInformationGroupEntry;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.muxer.Edit;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.muxer.samples.CencEncryptingSampleList;
import org.mp4parser.muxer.tracks.CencEncryptedTrack;
import org.mp4parser.muxer.tracks.h264.H264NalUnitHeader;
import org.mp4parser.muxer.tracks.h264.H264TrackImpl;
import org.mp4parser.muxer.tracks.h265.H265NalUnitHeader;
import org.mp4parser.muxer.tracks.h265.H265TrackImpl;
import org.mp4parser.tools.ByteBufferByteChannel;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeReaderVariable;
import org.mp4parser.tools.RangeStartMap;

public class CencEncryptingTrackImpl
implements CencEncryptedTrack {
    private final String encryptionAlgo;
    Track source;
    Map<UUID, SecretKey> keys = new HashMap<UUID, SecretKey>();
    UUID defaultKeyId;
    List<Sample> samples;
    List<CencSampleAuxiliaryDataFormat> cencSampleAuxiliaryData;
    boolean dummyIvs = false;
    boolean subSampleEncryption = false;
    SampleDescriptionBox stsd = null;
    RangeStartMap<Integer, SecretKey> indexToKey;
    Map<GroupEntry, long[]> sampleGroups;
    Object configurationBox;

    public CencEncryptingTrackImpl(Track source, UUID defaultKeyId, SecretKey key, boolean dummyIvs) {
        this(source, defaultKeyId, Collections.singletonMap(defaultKeyId, key), null, "cenc", dummyIvs);
    }

    public CencEncryptingTrackImpl(Track source, UUID defaultKeyId, Map<UUID, SecretKey> keys, Map<CencSampleEncryptionInformationGroupEntry, long[]> keyRotation, String encryptionAlgo, boolean dummyIvs) {
        this(source, defaultKeyId, keys, keyRotation, encryptionAlgo, dummyIvs, false);
    }

    public CencEncryptingTrackImpl(Track source, UUID defaultKeyId, Map<UUID, SecretKey> keys, Map<CencSampleEncryptionInformationGroupEntry, long[]> keyRotation, String encryptionAlgo, boolean dummyIvs, boolean encryptButAllClear) {
        this.source = source;
        this.keys = keys;
        this.defaultKeyId = defaultKeyId;
        this.dummyIvs = dummyIvs;
        this.encryptionAlgo = encryptionAlgo;
        this.sampleGroups = new HashMap<GroupEntry, long[]>();
        for (Map.Entry<GroupEntry, long[]> entry : source.getSampleGroups().entrySet()) {
            if (entry.getKey() instanceof CencSampleEncryptionInformationGroupEntry) continue;
            this.sampleGroups.put(entry.getKey(), entry.getValue());
        }
        if (keyRotation != null) {
            for (Map.Entry<GroupEntry, long[]> entry : keyRotation.entrySet()) {
                this.sampleGroups.put(entry.getKey(), entry.getValue());
            }
        }
        this.sampleGroups = new HashMap<GroupEntry, long[]>(this.sampleGroups){

            @Override
            public long[] put(GroupEntry key, long[] value) {
                if (key instanceof CencSampleEncryptionInformationGroupEntry) {
                    throw new RuntimeException("Please supply CencSampleEncryptionInformationGroupEntries in the constructor");
                }
                return super.put(key, value);
            }
        };
        this.samples = source.getSamples();
        this.cencSampleAuxiliaryData = new ArrayList<CencSampleAuxiliaryDataFormat>();
        BigInteger one = new BigInteger("1");
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        if (!dummyIvs) {
            SecureRandom random = new SecureRandom();
            ((Random)random).nextBytes(byArray);
        }
        BigInteger ivInt = new BigInteger(1, byArray);
        ArrayList<CencSampleEncryptionInformationGroupEntry> groupEntries = new ArrayList<CencSampleEncryptionInformationGroupEntry>();
        if (keyRotation != null) {
            groupEntries.addAll(keyRotation.keySet());
        }
        this.indexToKey = new RangeStartMap();
        int lastSampleGroupDescriptionIndex = -1;
        for (int i = 0; i < source.getSamples().size(); ++i) {
            int index = 0;
            for (int j = 0; j < groupEntries.size(); ++j) {
                GroupEntry groupEntry = (GroupEntry)groupEntries.get(j);
                long[] sampleNums = this.getSampleGroups().get(groupEntry);
                if (Arrays.binarySearch(sampleNums, (long)i) < 0) continue;
                index = j + 1;
            }
            if (lastSampleGroupDescriptionIndex == index) continue;
            if (index == 0) {
                this.indexToKey.put((Comparable)Integer.valueOf(i), (Object)keys.get(defaultKeyId));
            } else if (((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid() != null) {
                SecretKey sk = keys.get(((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid());
                if (sk == null) {
                    throw new RuntimeException("Key " + ((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid() + " was not supplied for decryption");
                }
                this.indexToKey.put((Comparable)Integer.valueOf(i), (Object)sk);
            } else {
                this.indexToKey.put((Comparable)Integer.valueOf(i), null);
            }
            lastSampleGroupDescriptionIndex = index;
        }
        List boxes = source.getSampleDescriptionBox().getSampleEntry().getBoxes();
        int nalLengthSize = -1;
        for (Box box : boxes) {
            if (box instanceof AvcConfigurationBox) {
                this.configurationBox = box;
                AvcConfigurationBox avcC = (AvcConfigurationBox)this.configurationBox;
                this.subSampleEncryption = true;
                nalLengthSize = avcC.getLengthSizeMinusOne() + 1;
            }
            if (!(box instanceof HevcConfigurationBox)) continue;
            this.configurationBox = box;
            HevcConfigurationBox hvcC = (HevcConfigurationBox)this.configurationBox;
            this.subSampleEncryption = true;
            nalLengthSize = hvcC.getLengthSizeMinusOne() + 1;
        }
        for (int i = 0; i < this.samples.size(); ++i) {
            Sample origSample = this.samples.get(i);
            CencSampleAuxiliaryDataFormat e = new CencSampleAuxiliaryDataFormat();
            this.cencSampleAuxiliaryData.add(e);
            if (this.indexToKey.get((Object)i) == null) continue;
            byte[] iv = ivInt.toByteArray();
            byte[] eightByteIv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            System.arraycopy(iv, iv.length - 8 > 0 ? iv.length - 8 : 0, eightByteIv, 8 - iv.length < 0 ? 0 : 8 - iv.length, iv.length > 8 ? 8 : iv.length);
            e.iv = eightByteIv;
            ByteBuffer sample = (ByteBuffer)origSample.asByteBuffer().rewind();
            if (this.subSampleEncryption) {
                if (encryptButAllClear) {
                    e.pairs = new CencSampleAuxiliaryDataFormat.Pair[]{e.createPair(sample.remaining(), 0L)};
                } else {
                    ArrayList<CencSampleAuxiliaryDataFormat.Pair> pairs = new ArrayList<CencSampleAuxiliaryDataFormat.Pair>(5);
                    while (sample.remaining() > 0) {
                        int nalLength = CastUtils.l2i((long)IsoTypeReaderVariable.read((ByteBuffer)sample, (int)nalLengthSize));
                        int nalGrossSize = nalLength + nalLengthSize;
                        int clearBytes = nalGrossSize < 112 || this.isClearNal(sample.duplicate()) ? nalGrossSize : 96 + nalGrossSize % 16;
                        pairs.add(e.createPair(clearBytes, (long)(nalGrossSize - clearBytes)));
                        sample.position(sample.position() + nalLength);
                    }
                    e.pairs = pairs.toArray(new CencSampleAuxiliaryDataFormat.Pair[pairs.size()]);
                }
            }
            ivInt = ivInt.add(one);
        }
    }

    @Override
    public UUID getDefaultKeyId() {
        return this.defaultKeyId;
    }

    @Override
    public boolean hasSubSampleEncryption() {
        return this.subSampleEncryption;
    }

    @Override
    public List<CencSampleAuxiliaryDataFormat> getSampleEncryptionEntries() {
        return this.cencSampleAuxiliaryData;
    }

    @Override
    public synchronized SampleDescriptionBox getSampleDescriptionBox() {
        if (this.stsd == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.source.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
                this.stsd = (SampleDescriptionBox)new IsoFile((ReadableByteChannel)new ByteBufferByteChannel(ByteBuffer.wrap(baos.toByteArray()))).getBoxes().get(0);
            }
            catch (IOException e) {
                throw new RuntimeException("Dumping stsd to memory failed");
            }
            OriginalFormatBox originalFormatBox = new OriginalFormatBox();
            originalFormatBox.setDataFormat(this.stsd.getSampleEntry().getType());
            if (this.stsd.getSampleEntry() instanceof AudioSampleEntry) {
                ((AudioSampleEntry)this.stsd.getSampleEntry()).setType("enca");
            } else if (this.stsd.getSampleEntry() instanceof VisualSampleEntry) {
                ((VisualSampleEntry)this.stsd.getSampleEntry()).setType("encv");
            } else {
                throw new RuntimeException("I don't know how to cenc " + this.stsd.getSampleEntry().getType());
            }
            ProtectionSchemeInformationBox sinf = new ProtectionSchemeInformationBox();
            sinf.addBox((Box)originalFormatBox);
            SchemeTypeBox schm = new SchemeTypeBox();
            schm.setSchemeType(this.encryptionAlgo);
            schm.setSchemeVersion(65536);
            sinf.addBox((Box)schm);
            SchemeInformationBox schi = new SchemeInformationBox();
            TrackEncryptionBox trackEncryptionBox = new TrackEncryptionBox();
            trackEncryptionBox.setDefaultIvSize(this.defaultKeyId == null ? 0 : 8);
            trackEncryptionBox.setDefaultAlgorithmId(this.defaultKeyId == null ? 0 : 1);
            trackEncryptionBox.setDefault_KID(this.defaultKeyId == null ? new UUID(0L, 0L) : this.defaultKeyId);
            schi.addBox((Box)trackEncryptionBox);
            sinf.addBox((Box)schi);
            this.stsd.getSampleEntry().addBox((Box)sinf);
        }
        return this.stsd;
    }

    @Override
    public long[] getSampleDurations() {
        return this.source.getSampleDurations();
    }

    @Override
    public long getDuration() {
        return this.source.getDuration();
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.source.getCompositionTimeEntries();
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.source.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return new CencEncryptingSampleList(this.indexToKey, this.source.getSamples(), this.cencSampleAuxiliaryData, this.encryptionAlgo);
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.source.getSubsampleInformationBox();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public String getName() {
        return "enc(" + this.source.getName() + ")";
    }

    @Override
    public List<Edit> getEdits() {
        return this.source.getEdits();
    }

    @Override
    public Map<GroupEntry, long[]> getSampleGroups() {
        return this.sampleGroups;
    }

    public boolean isClearNal(ByteBuffer s) {
        if (this.configurationBox instanceof HevcConfigurationBox) {
            H265NalUnitHeader nuh = H265TrackImpl.getNalUnitHeader(s.slice());
            return !(nuh.nalUnitType >= 0 && nuh.nalUnitType <= 9 || nuh.nalUnitType >= 16 && nuh.nalUnitType <= 21 || nuh.nalUnitType >= 16 && nuh.nalUnitType <= 21);
        }
        if (this.configurationBox instanceof AvcConfigurationBox) {
            H264NalUnitHeader nuh = H264TrackImpl.getNalUnitHeader(s.slice());
            return nuh.nal_unit_type != 19 && nuh.nal_unit_type != 2 && nuh.nal_unit_type != 3 && nuh.nal_unit_type != 4 && nuh.nal_unit_type != 20 && nuh.nal_unit_type != 5 && nuh.nal_unit_type != 1;
        }
        throw new RuntimeException("Subsample encryption is activated but the CencEncryptingTrackImpl can't say if this sample is to be encrypted or not!");
    }
}

