/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.muxer.Edit;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.TrackMetaData;

public class ChangeTimeScaleTrack
implements Track {
    private static final Logger LOG = Logger.getLogger(ChangeTimeScaleTrack.class.getName());
    Track source;
    List<CompositionTimeToSample.Entry> ctts;
    long[] decodingTimes;
    long timeScale;

    public ChangeTimeScaleTrack(Track source, long targetTimeScale, long[] syncSamples) {
        this.source = source;
        this.timeScale = targetTimeScale;
        double timeScaleFactor = (double)targetTimeScale / (double)source.getTrackMetaData().getTimescale();
        this.ctts = ChangeTimeScaleTrack.adjustCtts(source.getCompositionTimeEntries(), timeScaleFactor);
        this.decodingTimes = ChangeTimeScaleTrack.adjustTts(source.getSampleDurations(), timeScaleFactor, syncSamples, ChangeTimeScaleTrack.getTimes(source, syncSamples, targetTimeScale));
    }

    private static long[] getTimes(Track track, long[] syncSamples, long targetTimeScale) {
        long[] syncSampleTimes = new long[syncSamples.length];
        int currentSample = 1;
        long currentDuration = 0L;
        int currentSyncSampleIndex = 0;
        while ((long)currentSample <= syncSamples[syncSamples.length - 1]) {
            if ((long)currentSample == syncSamples[currentSyncSampleIndex]) {
                syncSampleTimes[currentSyncSampleIndex++] = currentDuration * targetTimeScale / track.getTrackMetaData().getTimescale();
            }
            currentDuration += track.getSampleDurations()[currentSample - 1];
            ++currentSample;
        }
        return syncSampleTimes;
    }

    static List<CompositionTimeToSample.Entry> adjustCtts(List<CompositionTimeToSample.Entry> source, double timeScaleFactor) {
        if (source != null) {
            ArrayList<CompositionTimeToSample.Entry> entries2 = new ArrayList<CompositionTimeToSample.Entry>(source.size());
            for (CompositionTimeToSample.Entry entry : source) {
                entries2.add(new CompositionTimeToSample.Entry(entry.getCount(), (int)Math.round(timeScaleFactor * (double)entry.getOffset())));
            }
            return entries2;
        }
        return null;
    }

    static long[] adjustTts(long[] sourceArray, double timeScaleFactor, long[] syncSample, long[] syncSampleTimes) {
        long summedDurations = 0L;
        long[] scaledArray = new long[sourceArray.length];
        for (int i = 1; i <= sourceArray.length; ++i) {
            long duration = sourceArray[i - 1];
            long x = Math.round(timeScaleFactor * (double)duration);
            int ssIndex = Arrays.binarySearch(syncSample, (long)(i + 1));
            if (ssIndex >= 0 && syncSampleTimes[ssIndex] != summedDurations) {
                long correction = syncSampleTimes[ssIndex] - (summedDurations + x);
                LOG.finest(String.format("Sample %d %d / %d - correct by %d", i, summedDurations, syncSampleTimes[ssIndex], correction));
                x += correction;
            }
            summedDurations += x;
            scaledArray[i - 1] = x;
        }
        return scaledArray;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        TrackMetaData trackMetaData = (TrackMetaData)this.source.getTrackMetaData().clone();
        trackMetaData.setTimescale(this.timeScale);
        return trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return this.source.getSamples();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.source.getSubsampleInformationBox();
    }

    @Override
    public long getDuration() {
        long duration = 0L;
        for (long delta : this.decodingTimes) {
            duration += delta;
        }
        return duration;
    }

    public String toString() {
        return "ChangeTimeScaleTrack{source=" + this.source + '}';
    }

    @Override
    public String getName() {
        return "timeScale(" + this.source.getName() + ")";
    }

    @Override
    public List<Edit> getEdits() {
        return this.source.getEdits();
    }

    @Override
    public Map<GroupEntry, long[]> getSampleGroups() {
        return this.source.getSampleGroups();
    }
}

