/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.mp4parser.Box;
import org.mp4parser.boxes.dolby.EC3SpecificBox;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitReaderBuffer;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.tools.CastUtils;

public class EC3TrackImpl
extends AbstractTrack {
    private static final long MAX_FRAMES_PER_MMAP = 20L;
    private final DataSource dataSource;
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox;
    private int bitrate;
    private int frameSize;
    private List<BitStreamInfo> bitStreamInfos = new LinkedList<BitStreamInfo>();
    private List<Sample> samples;
    private long[] decodingTimes;

    public EC3TrackImpl(DataSource dataSource) throws IOException {
        super(dataSource.toString());
        this.dataSource = dataSource;
        boolean done = false;
        while (!done) {
            BitStreamInfo bsi = this.readVariables();
            if (bsi == null) {
                throw new IOException();
            }
            for (BitStreamInfo entry : this.bitStreamInfos) {
                if (bsi.strmtyp == 1 || entry.substreamid != bsi.substreamid) continue;
                done = true;
            }
            if (done) continue;
            this.bitStreamInfos.add(bsi);
        }
        if (this.bitStreamInfos.size() == 0) {
            throw new IOException();
        }
        int samplerate = this.bitStreamInfos.get((int)0).samplerate;
        this.sampleDescriptionBox = new SampleDescriptionBox();
        AudioSampleEntry audioSampleEntry = new AudioSampleEntry("ec-3");
        audioSampleEntry.setChannelCount(2);
        audioSampleEntry.setSampleRate((long)samplerate);
        audioSampleEntry.setDataReferenceIndex(1);
        audioSampleEntry.setSampleSize(16);
        EC3SpecificBox ec3 = new EC3SpecificBox();
        int[] deps = new int[this.bitStreamInfos.size()];
        int[] chan_locs = new int[this.bitStreamInfos.size()];
        for (BitStreamInfo bsi : this.bitStreamInfos) {
            if (bsi.strmtyp != 1) continue;
            int n = bsi.substreamid;
            deps[n] = deps[n] + 1;
            chan_locs[bsi.substreamid] = bsi.chanmap >> 6 & 0x100 | bsi.chanmap >> 5 & 0xFF;
        }
        for (BitStreamInfo bsi : this.bitStreamInfos) {
            if (bsi.strmtyp != 1) {
                EC3SpecificBox.Entry e = new EC3SpecificBox.Entry();
                e.fscod = bsi.fscod;
                e.bsid = bsi.bsid;
                e.bsmod = bsi.bsmod;
                e.acmod = bsi.acmod;
                e.lfeon = bsi.lfeon;
                e.reserved = 0;
                e.num_dep_sub = deps[bsi.substreamid];
                e.chan_loc = chan_locs[bsi.substreamid];
                e.reserved2 = 0;
                ec3.addEntry(e);
            }
            this.bitrate += bsi.bitrate;
            this.frameSize += bsi.frameSize;
        }
        ec3.setDataRate(this.bitrate / 1000);
        audioSampleEntry.addBox((Box)ec3);
        this.sampleDescriptionBox.addBox((Box)audioSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setTimescale(samplerate);
        this.trackMetaData.setVolume(1.0f);
        dataSource.position(0L);
        this.samples = this.readSamples();
        this.decodingTimes = new long[this.samples.size()];
        Arrays.fill(this.decodingTimes, 1536L);
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    private BitStreamInfo readVariables() throws IOException {
        int numblkscod;
        long startPosition = this.dataSource.position();
        ByteBuffer bb = ByteBuffer.allocate(200);
        this.dataSource.read(bb);
        bb.rewind();
        BitReaderBuffer brb = new BitReaderBuffer(bb);
        int syncword = brb.readBits(16);
        if (syncword != 2935) {
            return null;
        }
        BitStreamInfo entry = new BitStreamInfo();
        entry.strmtyp = brb.readBits(2);
        entry.substreamid = brb.readBits(3);
        int frmsiz = brb.readBits(11);
        entry.frameSize = 2 * (frmsiz + 1);
        entry.fscod = brb.readBits(2);
        int fscod2 = -1;
        if (entry.fscod == 3) {
            fscod2 = brb.readBits(2);
            numblkscod = 3;
        } else {
            numblkscod = brb.readBits(2);
        }
        int numberOfBlocksPerSyncFrame = 0;
        switch (numblkscod) {
            case 0: {
                numberOfBlocksPerSyncFrame = 1;
                break;
            }
            case 1: {
                numberOfBlocksPerSyncFrame = 2;
                break;
            }
            case 2: {
                numberOfBlocksPerSyncFrame = 3;
                break;
            }
            case 3: {
                numberOfBlocksPerSyncFrame = 6;
            }
        }
        entry.frameSize *= 6 / numberOfBlocksPerSyncFrame;
        entry.acmod = brb.readBits(3);
        entry.lfeon = brb.readBits(1);
        entry.bsid = brb.readBits(5);
        brb.readBits(5);
        if (1 == brb.readBits(1)) {
            brb.readBits(8);
        }
        if (0 == entry.acmod) {
            brb.readBits(5);
            if (1 == brb.readBits(1)) {
                brb.readBits(8);
            }
        }
        if (1 == entry.strmtyp && 1 == brb.readBits(1)) {
            entry.chanmap = brb.readBits(16);
        }
        if (1 == brb.readBits(1)) {
            if (entry.acmod > 2) {
                brb.readBits(2);
            }
            if (1 == (entry.acmod & 1) && entry.acmod > 2) {
                brb.readBits(3);
                brb.readBits(3);
            }
            if (0 < (entry.acmod & 4)) {
                brb.readBits(3);
                brb.readBits(3);
            }
            if (1 == entry.lfeon && 1 == brb.readBits(1)) {
                brb.readBits(5);
            }
            if (0 == entry.strmtyp) {
                int mixdef;
                if (1 == brb.readBits(1)) {
                    brb.readBits(6);
                }
                if (0 == entry.acmod && 1 == brb.readBits(1)) {
                    brb.readBits(6);
                }
                if (1 == brb.readBits(1)) {
                    brb.readBits(6);
                }
                if (1 == (mixdef = brb.readBits(2))) {
                    brb.readBits(5);
                } else if (2 == mixdef) {
                    brb.readBits(12);
                } else if (3 == mixdef) {
                    int mixdeflen = brb.readBits(5);
                    if (1 == brb.readBits(1)) {
                        brb.readBits(5);
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            brb.readBits(4);
                        }
                        if (1 == brb.readBits(1)) {
                            if (1 == brb.readBits(1)) {
                                brb.readBits(4);
                            }
                            if (1 == brb.readBits(1)) {
                                brb.readBits(4);
                            }
                        }
                    }
                    if (1 == brb.readBits(1)) {
                        brb.readBits(5);
                        if (1 == brb.readBits(1)) {
                            brb.readBits(7);
                            if (1 == brb.readBits(1)) {
                                brb.readBits(8);
                            }
                        }
                    }
                    for (int i = 0; i < mixdeflen + 2; ++i) {
                        brb.readBits(8);
                    }
                    brb.byteSync();
                }
                if (entry.acmod < 2) {
                    if (1 == brb.readBits(1)) {
                        brb.readBits(14);
                    }
                    if (0 == entry.acmod && 1 == brb.readBits(1)) {
                        brb.readBits(14);
                    }
                    if (1 == brb.readBits(1)) {
                        if (numblkscod == 0) {
                            brb.readBits(5);
                        } else {
                            for (int i = 0; i < numberOfBlocksPerSyncFrame; ++i) {
                                if (1 != brb.readBits(1)) continue;
                                brb.readBits(5);
                            }
                        }
                    }
                }
            }
        }
        if (1 == brb.readBits(1)) {
            entry.bsmod = brb.readBits(3);
        }
        block6 : switch (entry.fscod) {
            case 0: {
                entry.samplerate = 48000;
                break;
            }
            case 1: {
                entry.samplerate = 44100;
                break;
            }
            case 2: {
                entry.samplerate = 32000;
                break;
            }
            case 3: {
                switch (fscod2) {
                    case 0: {
                        entry.samplerate = 24000;
                        break block6;
                    }
                    case 1: {
                        entry.samplerate = 22050;
                        break block6;
                    }
                    case 2: {
                        entry.samplerate = 16000;
                        break block6;
                    }
                    case 3: {
                        entry.samplerate = 0;
                    }
                }
            }
        }
        if (entry.samplerate == 0) {
            return null;
        }
        entry.bitrate = (int)((double)entry.samplerate / 1536.0 * (double)entry.frameSize * 8.0);
        this.dataSource.position(startPosition + (long)entry.frameSize);
        return entry;
    }

    private List<Sample> readSamples() throws IOException {
        int framesLeft = CastUtils.l2i((long)((this.dataSource.size() - this.dataSource.position()) / (long)this.frameSize));
        ArrayList<Sample> mySamples = new ArrayList<Sample>(framesLeft);
        for (int i = 0; i < framesLeft; ++i) {
            final int start = i * this.frameSize;
            mySamples.add(new Sample(){

                @Override
                public void writeTo(WritableByteChannel channel) throws IOException {
                    EC3TrackImpl.this.dataSource.transferTo(start, EC3TrackImpl.this.frameSize, channel);
                }

                @Override
                public long getSize() {
                    return EC3TrackImpl.this.frameSize;
                }

                @Override
                public ByteBuffer asByteBuffer() {
                    try {
                        return EC3TrackImpl.this.dataSource.map(start, EC3TrackImpl.this.frameSize);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return mySamples;
    }

    public String toString() {
        return "EC3TrackImpl{bitrate=" + this.bitrate + ", bitStreamInfos=" + this.bitStreamInfos + '}';
    }

    public static class BitStreamInfo
    extends EC3SpecificBox.Entry {
        public int frameSize;
        public int substreamid;
        public int bitrate;
        public int samplerate;
        public int strmtyp;
        public int chanmap;

        public String toString() {
            return "BitStreamInfo{frameSize=" + this.frameSize + ", substreamid=" + this.substreamid + ", bitrate=" + this.bitrate + ", samplerate=" + this.samplerate + ", strmtyp=" + this.strmtyp + ", chanmap=" + this.chanmap + '}';
        }
    }
}

