/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitReaderBuffer;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderConfigDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ESDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.SLConfigDescriptor;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part14.ESDescriptorBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.SampleImpl;
import org.mp4parser.muxer.TrackMetaData;

public class MP3TrackImpl
extends AbstractTrack {
    private static final int MPEG_V1 = 3;
    private static final int MPEG_L3 = 1;
    private static final int[] SAMPLE_RATE = new int[]{44100, 48000, 32000, 0};
    private static final int[] BIT_RATE = new int[]{0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0};
    private static final int SAMPLES_PER_FRAME = 1152;
    private static final int ES_OBJECT_TYPE_INDICATION = 107;
    private static final int ES_STREAM_TYPE = 5;
    private final DataSource dataSource;
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox;
    MP3Header firstHeader;
    long maxBitRate;
    long avgBitRate;
    private List<Sample> samples;
    private long[] durations;

    public MP3TrackImpl(DataSource channel) throws IOException {
        this(channel, "eng");
    }

    public MP3TrackImpl(DataSource dataSource, String lang) throws IOException {
        super(dataSource.toString());
        this.dataSource = dataSource;
        this.samples = new LinkedList<Sample>();
        this.firstHeader = this.readSamples(dataSource);
        double packetsPerSecond = (double)this.firstHeader.sampleRate / 1152.0;
        double duration = (double)this.samples.size() / packetsPerSecond;
        long dataSize = 0L;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (Sample sample : this.samples) {
            int size = (int)sample.getSize();
            dataSize += (long)size;
            queue.add(size);
            while ((double)queue.size() > packetsPerSecond) {
                queue.pop();
            }
            if (queue.size() != (int)packetsPerSecond) continue;
            int currSize = 0;
            for (Integer aQueue : queue) {
                currSize += aQueue.intValue();
            }
            double currBitRate = 8.0 * (double)currSize / (double)queue.size() * packetsPerSecond;
            if (!(currBitRate > (double)this.maxBitRate)) continue;
            this.maxBitRate = (int)currBitRate;
        }
        this.avgBitRate = (int)((double)(8L * dataSize) / duration);
        this.sampleDescriptionBox = new SampleDescriptionBox();
        AudioSampleEntry audioSampleEntry = new AudioSampleEntry("mp4a");
        audioSampleEntry.setChannelCount(this.firstHeader.channelCount);
        audioSampleEntry.setSampleRate((long)this.firstHeader.sampleRate);
        audioSampleEntry.setDataReferenceIndex(1);
        audioSampleEntry.setSampleSize(16);
        ESDescriptorBox esds = new ESDescriptorBox();
        ESDescriptor descriptor = new ESDescriptor();
        descriptor.setEsId(0);
        SLConfigDescriptor slConfigDescriptor = new SLConfigDescriptor();
        slConfigDescriptor.setPredefined(2);
        descriptor.setSlConfigDescriptor(slConfigDescriptor);
        DecoderConfigDescriptor decoderConfigDescriptor = new DecoderConfigDescriptor();
        decoderConfigDescriptor.setObjectTypeIndication(107);
        decoderConfigDescriptor.setStreamType(5);
        decoderConfigDescriptor.setMaxBitRate(this.maxBitRate);
        decoderConfigDescriptor.setAvgBitRate(this.avgBitRate);
        descriptor.setDecoderConfigDescriptor(decoderConfigDescriptor);
        ByteBuffer data = descriptor.serialize();
        esds.setData(data);
        audioSampleEntry.addBox((Box)esds);
        this.sampleDescriptionBox.addBox((Box)audioSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(lang);
        this.trackMetaData.setVolume(1.0f);
        this.trackMetaData.setTimescale(this.firstHeader.sampleRate);
        this.durations = new long[this.samples.size()];
        Arrays.fill(this.durations, 1152L);
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public long[] getSampleDurations() {
        return this.durations;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    private MP3Header readSamples(DataSource channel) throws IOException {
        MP3Header first = null;
        while (true) {
            long pos = channel.position();
            MP3Header hdr = this.readMP3Header(channel);
            if (hdr == null) break;
            if (first == null) {
                first = hdr;
            }
            channel.position(pos);
            ByteBuffer data = ByteBuffer.allocate(hdr.getFrameLength());
            channel.read(data);
            data.rewind();
            this.samples.add(new SampleImpl(data));
        }
        return first;
    }

    private MP3Header readMP3Header(DataSource channel) throws IOException {
        MP3Header hdr = new MP3Header();
        ByteBuffer bb = ByteBuffer.allocate(4);
        while (bb.position() < 4) {
            if (channel.read(bb) != -1) continue;
            return null;
        }
        if (bb.get(0) == 84 && bb.get(1) == 65 && bb.get(2) == 71) {
            return null;
        }
        BitReaderBuffer brb = new BitReaderBuffer((ByteBuffer)bb.rewind());
        int sync = brb.readBits(11);
        if (sync != 2047) {
            throw new IOException("Expected Start Word 0x7ff");
        }
        hdr.mpegVersion = brb.readBits(2);
        if (hdr.mpegVersion != 3) {
            throw new IOException("Expected MPEG Version 1 (ISO/IEC 11172-3)");
        }
        hdr.layer = brb.readBits(2);
        if (hdr.layer != 1) {
            throw new IOException("Expected Layer III");
        }
        hdr.protectionAbsent = brb.readBits(1);
        hdr.bitRateIndex = brb.readBits(4);
        hdr.bitRate = BIT_RATE[hdr.bitRateIndex];
        if (hdr.bitRate == 0) {
            throw new IOException("Unexpected (free/bad) bit rate");
        }
        hdr.sampleFrequencyIndex = brb.readBits(2);
        hdr.sampleRate = SAMPLE_RATE[hdr.sampleFrequencyIndex];
        if (hdr.sampleRate == 0) {
            throw new IOException("Unexpected (reserved) sample rate frequency");
        }
        hdr.padding = brb.readBits(1);
        brb.readBits(1);
        hdr.channelMode = brb.readBits(2);
        hdr.channelCount = hdr.channelMode == 3 ? 1 : 2;
        return hdr;
    }

    public String toString() {
        return "MP3TrackImpl";
    }

    class MP3Header {
        int mpegVersion;
        int layer;
        int protectionAbsent;
        int bitRateIndex;
        int bitRate;
        int sampleFrequencyIndex;
        int sampleRate;
        int padding;
        int channelMode;
        int channelCount;

        MP3Header() {
        }

        int getFrameLength() {
            return 144 * this.bitRate / this.sampleRate + this.padding;
        }
    }
}

